<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Clicks_admin extends MY_Controller
{
    private $dir = 'clicks_admin';
    private $nom = 'Cantidad de prestaciones';
    private $dir1 = 'Consultar cantidad de prestaciones';
    private $dir2 = 'Editar Clicks';

    private $user_reg = '';

    function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('ubicacion') != $this->dir):
            $array_items = array('per_page' => NULL, 'sort_order' => NULL, 'sort_by' => NULL,);
            $this->session->unset_userdata($array_items);
            $this->session->set_userdata('ubicacion', $this->dir);
        endif;

        $this->user_reg = $this->session->userdata('user_reg');

        $this->load->model($this->dir . '_model', 'modelo', TRUE);
        $this->data['dir'] = $this->dir;
        $this->data['nom'] = $this->nom;
        $this->data['dir1'] = $this->dir1;
        $this->data['dir2'] = $this->dir2;
    }

    function index()
    {
        $this->data['action'] = site_url('admin/' . $this->dir . '/update');

        $this->load->model('admin/empresas_model', '', TRUE);
        $sql['habilitado'] = 1;
        $empresas = $this->empresas_model->getAll($sql);
        $this->data['empresas'] = $empresas['rows'];

        if ($this->session->flashdata('template_msg'))
            $this->data['message'] = $this->session->flashdata('template_msg');

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/edit', $this->data);
    }

    function edit()
    {
        $this->template->title($this->data['nombre'] . ' :: Administración');
        $this->template->build('admin/' . $this->dir . '/edit', $this->data);
    }

    function update()
    {
        /* - Campos requeridos - */
        $this->form_validation->set_rules('empresa', 'Empresa', 'required');
        $this->form_validation->set_rules('fecha_desde', 'Fecha desde', 'required');
        $this->form_validation->set_rules('fecha_hasta', 'Fecha hasta', 'required');

        if ($this->form_validation->run() == FALSE):

            $this->data['action'] = site_url('admin/' . $this->dir . '/update');

            $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Errores !</h4>" . validation_errors() . "</div>";

            $this->template->title($this->data['nombre'] . ' :: Administración');

            $this->template->build('admin/' . $this->dir . '/edit', $this->data);

        else:

            $this->data['fields'] = $this->modelo->getCampos();

            $objeto = array(
                'empresa' => $this->input->post('empresa'),
                'group_by' => TRUE,
                'fecha_desde' => $this->input->post('fecha_desde'),
                'fecha_hasta' => $this->input->post('fecha_hasta')
            );

            $reporte = $this->modelo->getAll($objeto);
            $this->data['rows'] = $reporte['rows'];
            $this->data['totalizador'] = $reporte['num_rows'];

            $this->data['fecha_desde'] = $this->input->post('fecha_desde');
            $this->data['fecha_hasta'] = $this->input->post('fecha_hasta');

            $this->template->title($this->data['nombre'], 'Administración');
            $this->template->build('admin/' . $this->dir . '/list', $this->data);

        endif;
    }

    function delete()
    {
        $this->modelo->delete($this->input->post('ele'));
        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        redirect('admin/' . $this->dir . '/index', 'refresh');
    }

    function detalleProfesional($id, $desde = '', $hasta = '')
    {
        $this->data['fields'] = array(
            'entrada' => 'Entrada',
            'salida' => 'Salida',
            'semaforo' => 'Semaforo',
            'cantidad' => 'Cantidad'
        );

        $objeto = array(
            'empresa' => $this->user_reg['company'],
            'sucursal' => $this->user_reg['sucursal'],
            'id' => $id,
            'fecha_desde' => $desde,
            'fecha_hasta' => $hasta
        );

        $detalle = $this->modelo->obtenerDetalle($objeto);
        $this->data['rows'] = $detalle['rows'];

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/detalleProfesional', $this->data);
    }

    function detallePaciente($id, $desde = '', $hasta = '')
    {
        $this->data['fields'] = array(
            'entrada' => 'Entrada',
            'salida' => 'Salida',
            'semaforo' => 'Semaforo',
            'cantidad' => 'Cantidad'
        );

        $objeto = array(
            'empresa' => $this->user_reg['company'],
            'sucursal' => $this->user_reg['sucursal'],
            'id' => $id,
            'fecha_desde' => $desde,
            'fecha_hasta' => $hasta
        );

        $detalle = $this->modelo->obtenerDetalle($objeto);
        $this->data['rows'] = $detalle['rows'];

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/detallePaciente', $this->data);
    }

    function detalleLocalidad($id, $desde = '', $hasta = '')
    {
        $this->data['fields'] = array(
            'nombrePaciente' => 'Paciente',
            'nombreProfesional' => 'Profesional',
            'especialidad' => 'Especialidad',
            'entrada' => 'Entrada',
            'salida' => 'Salida',
            'semaforo' => 'Semaforo',
            'cantidad' => 'Cantidad'
        );

        $objeto = array(
            'empresa' => $this->user_reg['company'],
            'sucursal' => $this->user_reg['sucursal'],
            'id' => $id,
            'fecha_desde' => $desde,
            'fecha_hasta' => $hasta
        );

        $detalle = $this->modelo->obtenerDetalle($objeto);
        $this->data['rows'] = $detalle['rows'];

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/detalleLocalidad', $this->data);
    }

    function exportarExcel($desde = null, $hasta = null)
    {
        $objeto = array(
            'empresa' => $this->user_reg['company'],
            'sucursal' => $this->user_reg['sucursal'],
            'fecha_desde' => $desde,
            'fecha_hasta' => $hasta
        );
        $this->modelo->exportarExcel($objeto);
    }
}