package com.ensoft.medicontrol.ui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.provider.Settings;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;

public class DialogGPS extends DialogFragment
{
	boolean salir = true;
	
	@Override
	public Dialog onCreateDialog( Bundle savedInstanceState )
	{
		// Use the Builder class for convenient dialog construction
		AlertDialog.Builder builder = new AlertDialog.Builder( getActivity() );
		builder.setTitle( "Activar servicios de ubicación" );
		builder.setMessage( "Por favor active la ubicación del dispositivo para continuar" )
			.setPositiveButton( "Activar", new DialogInterface.OnClickListener()
			{
				public void onClick( DialogInterface dialog, int id )
				{
					salir = false;
					Intent onGPS = new Intent( Settings.ACTION_LOCATION_SOURCE_SETTINGS );
					startActivity( onGPS );
				}
			} )
			.setNegativeButton( "Salir", new DialogInterface.OnClickListener()
			{
				public void onClick( DialogInterface dialog, int id )
				{
					getActivity().finish();
				}
			} );
		
		// Create the AlertDialog object and return it
		return builder.create();
	}
	
	@Override
	public void onDismiss( DialogInterface dialog )
	{
		if ( salir )
		{
			getActivity().finish();
		}
		
		super.onDismiss( dialog );
	}
}
