package com.ensoft.medicontrol.ui.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import com.ensoft.medicontrol.infrastructure.service.LocationService;

public class LocationServicesReceiver extends BroadcastReceiver
{
	public LocationServicesReceiver(LocationServiceListener handler)
	{
		mReceiverHandler = handler;
	}

	LocationServiceListener mReceiverHandler;

	public interface LocationServiceListener
	{
		void onLocationServicesEnabled();

		void onLocationServicesDisabled();
	}

	@Override
	public void onReceive(final Context context, final Intent intent)
	{
		LocationService locationService = new LocationService(context);

		if (locationService.isEnable())
		{
			mReceiverHandler.onLocationServicesEnabled();
		} else
		{
			mReceiverHandler.onLocationServicesDisabled();
		}
	}

	public IntentFilter getIntentFilter()
	{
		IntentFilter locationServicesChangeFilter = new IntentFilter();

		//locationServicesChangeFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
		locationServicesChangeFilter.addAction("android.location.GPS_ENABLED_CHANGE");

		return locationServicesChangeFilter;
	}
}
