package com.ensoft.medicontrol.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputEditText;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.R;
import com.ensoft.medicontrol.domain.model.UserModel;
import com.ensoft.medicontrol.infrastructure.request.LoginRequest;
import com.ensoft.medicontrol.infrastructure.request.RememberPasswordRequest;
import com.ensoft.medicontrol.infrastructure.responseDTO.ResponseMessage;

import butterknife.Bind;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class LoginActivity extends BaseActivity
{
	public static final String TAG = LoginActivity.class.getCanonicalName();

	protected long loginReqId;
	protected long recoverPasswordReqId;

	@Bind( R.id.username_edit )
	protected EditText usernameEdit;

	@Bind( R.id.password_edit )
	protected TextInputEditText passwordEdit;

	@Override
	protected void onCreate( @Nullable Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		setContentView( R.layout.activity_login );

		ButterKnife.bind( this );
	}

	@Override
	protected void onPostCreate( @Nullable Bundle savedInstanceState )
	{
		super.onPostCreate( savedInstanceState );

		setUI();

		UserModel user = App.getInstance().getPreferencesService().getUser();

		if ( user != null && user.getToken() != null && !user.getToken().isEmpty() )
		{
			startActivity( new Intent( LoginActivity.this, PatientsActivity.class ).setFlags( Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK ) );
			overridePendingTransition(0, 0);
		}
	}

	public void setUI()
	{
		UserModel userModel = App.getInstance().getPreferencesService().getUser();

		if ( null != userModel )
		{
			usernameEdit.setText( userModel.getUser() );
		}
	}

	@OnClick( R.id.login_button )
	protected void onLoginClick()
	{
		if ( usernameEdit.getText().length() > 0 && passwordEdit.getText().length() > 0 )
		{
			doLogin();
		}
		else
		{
			Toast.makeText( this, "Error: Complete todos los campos para continuar", Toast.LENGTH_SHORT ).show();
		}
	}

	@OnClick( R.id.recover_password_button )
	public void onRecoverPasswordClick( View view )
	{
		if ( usernameEdit.getText().length() > 0 )
		{
			recoverPassword();
		}
		else
		{
			Toast.makeText( this, "Error: Complete el usuario para continuar", Toast.LENGTH_SHORT ).show();
		}
	}
	
	void recoverPassword()
	{
		createdDialog( "Recuperando contraseña" );
		
		getRequestReceiverService().addRequest( recoverPasswordReqId = RememberPasswordRequest.addRequest( usernameEdit.getText().toString() ) );
	}
	
	void createLoginDialog()
	{
		createdDialog( "Accediendo" );
	}
	
	void doLogin()
	{
		hideSoftKeyboard();
		
		createLoginDialog();

		getRequestReceiverService().addRequest( loginReqId = LoginRequest.addRequest( usernameEdit.getText().toString(), passwordEdit.getText().toString() ) );
	}

	@Override
	public void onRequestSuccess( long requestId )
	{
		if ( requestId == loginReqId )
		{
			closeDialog();

			finish();

			startActivity( new Intent( LoginActivity.this, PatientsActivity.class ) );
		}
		else if ( requestId == recoverPasswordReqId )
		{
			closeDialog();
			
			ResponseMessage message = (ResponseMessage)App.getInstance().getResponseManager().get( requestId );
			
			Toast.makeText( this, message.getMessage(), Toast.LENGTH_SHORT ).show();
		}
	}

	@Override
	public void onRequestError( long requestId, int resultCode, String resultMsg )
	{
		if ( requestId == loginReqId )
		{
			closeDialog();
		}
		
		errorMessageFromResponse( resultMsg );
	}

	@Override
	public void onRequestFinished( long requestId )
	{
		App.getInstance().getResponseManager().remove( requestId );
	}
}
