package com.ensoft.medicontrol.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputEditText;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.R;
import com.ensoft.medicontrol.infrastructure.request.ChangePasswordRequest;

import butterknife.Bind;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class ConfigActivity extends BaseActivity
{
	public static final String TAG = ConfigActivity.class.getCanonicalName();
	
	@Bind( R.id.old_pass_edit )
	protected TextInputEditText oldPassEdit;
	
	@Bind( R.id.new_pass_edit )
	protected TextInputEditText passEdit;
	
	@Bind( R.id.change_pass_button )
	protected Button changePassButton;
	
	@Bind( R.id.logout_button )
	protected TextView logoutButton;
	
	@Bind( R.id.change_acc_button )
	protected TextView changeAccButton;
	
	protected long changePassReqId;
	
	@Override
	protected void onCreate( @Nullable Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		
		setContentView( R.layout.activity_config );
		
		ButterKnife.bind( this );
		
		setTitle( "Configuración" );
	}
	
	@OnClick( R.id.logout_button )
	public void onLogoutClick( View view )
	{
		App.getInstance().getPreferencesService().clearAll();

		startActivity( new Intent( ConfigActivity.this, LoginActivity.class ).setFlags( Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK ) );
	}
	
	@OnClick( R.id.change_pass_button )
	public void onChangePassClick( View view )
	{
		if ( !checkErrors() )
		{
			changePassword();
		}
	}
	
	@OnClick( R.id.change_acc_button )
	public void onChangeAccountClick( View view )
	{
		Intent intent = new Intent( ConfigActivity.this, UsersActivity.class );
		
		startActivity( intent );
	}
	
	void changePassword()
	{
		createdDialog( "Cambiando contraseña" );
		
		getRequestReceiverService().addRequest( changePassReqId =
			ChangePasswordRequest.addRequest( oldPassEdit.getText().toString(), passEdit.getText().toString() )
		);
		
		hideSoftKeyboard();
	}
	
	boolean checkErrors()
	{
		boolean rta = false;
		
		if ( oldPassEdit.getText().toString().length() == 0 )
		{
			rta = true;
			Toast.makeText( ConfigActivity.this, "Debe completar su contraseña actual", Toast.LENGTH_SHORT ).show();
		}
		
		if ( passEdit.getText().toString().length() == 0 )
		{
			rta = true;
			Toast.makeText( ConfigActivity.this, "Debe completar su contraseña nueva", Toast.LENGTH_SHORT ).show();
		}
		
		if ( passEdit.getText().toString().length() < 8 )
		{
			rta = true;
			Toast.makeText( ConfigActivity.this, "Su contraseña nueva debe tener al menos 8 caracteres", Toast.LENGTH_SHORT ).show();
		}
		
		return rta;
	}
	
	@Override
	public void onRequestSuccess( long requestId )
	{
		if ( requestId == changePassReqId )
		{
			Toast.makeText( this, "Contraseña actualizada exitosamente.", Toast.LENGTH_SHORT ).show();
			
			oldPassEdit.getText().clear();
			
			passEdit.getText().clear();
			
			closeDialog();
		}
	}
	
	@Override
	public void onRequestError( long requestId, int resultCode, String resultMsg )
	{
		closeDialog();
		
		errorMessageFromResponse( resultMsg );
	}
	
	@Override
	public void onRequestFinished( long requestId )
	{
		App.getInstance().getResponseManager().remove( requestId );
	}
}
