package com.ensoft.medicontrol.infrastructure.service;

import android.util.Log;

import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.domain.model.PatientModel;
import com.ensoft.medicontrol.domain.model.UserModel;
import com.ensoft.medicontrol.domain.model.VisitModel;
import com.ensoft.medicontrol.domain.table.PatientTable;
import com.ensoft.medicontrol.domain.table.VisitTable;

public class VisitService
{
	public static final String TAG = VisitService.class.getCanonicalName();
	
	public void endVisits( String notificationTitle )
	{
		Log.d( TAG, "VisitService.endVisits called");
		
		UserModel user = App.getInstance().getPreferencesService().getUser();
		
		if ( null != user )
		{
			VisitTable visitTable = new VisitTable();
			VisitModel[] visits = visitTable.getVisits( user.getId() );
			
			if ( null != visits && visits.length > 0 )
			{
				for ( VisitModel visit : visits  )
				{
					App.getInstance().getNotificationServiceProvider().visitCancel();
					
					PatientModel patient = new PatientTable().getModelFromId( visit.getPatientId() );
					
					if ( null != patient )
					{
						App.getInstance().getNotificationServiceProvider().visitEnded( notificationTitle, patient.getName() );
					}
					
					Log.d( TAG, "Deleted visit from patient: " + visit.getPatientId() );
					
					visit.delete();
				}
			}
		}
	}
}
