package com.ensoft.medicontrol.infrastructure.service;

import android.app.Service;
import android.os.IInterface;
import android.os.RemoteCallbackList;

public abstract class ServiceWithCallbacks<T extends IInterface> extends Service
{
	final private RemoteCallbackList<T> callbacks = new RemoteCallbackList<>();

	protected void addCallback(T callback)
	{
		callbacks.register(callback);
	}

	protected void removeCallback(T callback)
	{
		callbacks.unregister(callback);
	}

	protected abstract class CallbackBroadcaster
	{
		public abstract void run( T item);
	}

	protected void broadcastCallback(CallbackBroadcaster cbb)
	{
		final int N = callbacks.beginBroadcast();

		for ( int i = 0; i < N; i++ )
		{
			cbb.run( callbacks.getBroadcastItem(i) );
		}

		callbacks.finishBroadcast();
	}
}
