package com.ensoft.medicontrol.infrastructure.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;

import com.app.ensoft.medicontrol.infrastructure.service.INotificationService;
import com.app.ensoft.medicontrol.infrastructure.service.INotificationServiceCallback;
import com.ensoft.medicontrol.infrastructure.event.NotificationEvent;

import org.greenrobot.eventbus.EventBus;

public class NotificationServiceProvider
{
	protected INotificationService service;
	protected Context context;

	public NotificationServiceProvider( Context context )
	{
		this.context = context;

		checkService();
	}

	private ServiceConnection connection = new ServiceConnection()
	{
		@Override public void onServiceConnected( ComponentName className, IBinder service)
		{
			NotificationServiceProvider.this.service = INotificationService.Stub.asInterface( service );

			try
			{
				NotificationServiceProvider.this.service.registerCallback( serviceCallback );
			}
			catch ( RemoteException e )
			{}
		}

		@Override public void onServiceDisconnected(ComponentName arg0)
		{
			service = null;
		}
	};

	final private INotificationServiceCallback serviceCallback = new INotificationServiceCallback.Stub()
	{
		@Override
		public void onVisitNotificationEnded() throws RemoteException
		{
			EventBus.getDefault().post( new NotificationEvent.onVisitEnded() );
		}
	};

	private void checkService()
	{
		if ( service == null )
		{
			Intent serviceIntent = new Intent( context, NotificationService.class );
			context.startService( serviceIntent );
			context.bindService( serviceIntent, connection, 0 );
		}
	}

	public void createVisit( String name, long when, long length )
	{
		try
		{
			if ( null != service )
				service.createVisit( name, when, length );
		}
		catch ( RemoteException e )
		{}
	}

	public void visitEnded( String title, String name )
	{
		try
		{
			if ( null != service )
				service.visitEnded( title, name );
		}
		catch ( RemoteException e )
		{}
	}

	public void visitCancel()
	{
		try
		{
			if ( null != service )
				service.visitCancel();
		}
		catch ( RemoteException e )
		{}
	}

	public void destroy()
	{
		try
		{
			if ( service != null )
			{
				service.unregisterCallback( serviceCallback );
			}
		}
		catch ( RemoteException e )
		{
			e.printStackTrace();
		}

		context.unbindService( connection );
	}
}
