package com.ensoft.medicontrol.infrastructure.service;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;

import com.ensoft.medicontrol.R;
import com.ensoft.medicontrol.ui.activity.LoginActivity;

public class NotificationBuilderService
{
	public static final int VISIT_CARD_ID = 1;
	public static final int VISIT_ENDED_ID = 2;

	public NotificationCompat.Builder getBasicBuilder( Context context, Intent openIntent, String title, String messageBody )
	{
		PendingIntent pendingIntent = PendingIntent.getActivity( context, 0 /* Request code */, openIntent, PendingIntent.FLAG_ONE_SHOT );
		
		return new NotificationCompat.Builder(context)
			.setSmallIcon( R.drawable.ic_add_alert_white_24dp )
			.setColor( context.getResources().getColor( R.color.colorPrimary ) )
			.setContentTitle( title )
			.setContentText( messageBody )
			.setContentIntent( pendingIntent );
	}
	
	public void sendNotification( Context context, Notification notification, int id )
	{
		NotificationManager notificationManager = (NotificationManager) context.getSystemService( Context.NOTIFICATION_SERVICE );
		notificationManager.notify( id /* ID of notification */, notification );
	}
	
	public void sendNotification( Context context, NotificationCompat.Builder notificationBuilder, int id )
	{
		sendNotification( context, notificationBuilder.build(), id );
	}
	
	public void sendVisitEnded( Context context, int id, String title, String name )
	{
		Intent intent = new Intent( context, LoginActivity.class );
		intent.addFlags( Intent.FLAG_ACTIVITY_CLEAR_TOP );
		
		Uri defaultSoundUri= RingtoneManager.getDefaultUri( RingtoneManager.TYPE_NOTIFICATION );
		
		NotificationCompat.Builder notificationBuilder = getBasicBuilder( context, intent, title, name )
			.setAutoCancel( true )
			.setSound( defaultSoundUri );
		
		sendNotification( context, notificationBuilder, id );
	}


	public Notification createVisitNotification( Context context, String name, long when )
	{
		Intent intent = new Intent( context, LoginActivity.class );
		intent.addFlags( Intent.FLAG_ACTIVITY_CLEAR_TOP );

		NotificationCompat.Builder notificationBuilder = getBasicBuilder( context, intent, "Visita Activa", name )
			.setShowWhen( true )
			.setUsesChronometer( true )
			.setWhen( when )
			.setOngoing(true);

		Notification notification = notificationBuilder.build();
		notification.flags |= Notification.FLAG_ONGOING_EVENT;

		return notification;
	}

	public void createVisit( Context context, int id, String name, long when, long length )
	{
		sendNotification( context, createVisitNotification( context, name, when ), id );
	}
	
	public void cancel( Context context, int id )
	{
		NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
		notificationManager.cancel( id );
	}
	
	public void cancelAll( Context context )
	{
		NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
		notificationManager.cancelAll();
	}
}
