package com.ensoft.medicontrol.infrastructure.service;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.util.Log;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationSettingsStatusCodes;

public class LocationService
{
	public final static int REQUEST_LOCATION = 199;
	private Context mContext;
	private GoogleApiClient googleApiClient;

	public LocationService(Context context)
	{
		mContext = context;
	}

	public boolean isEnable()
	{
		return /*isOnline() &&*/ isGpsEnable();
	}

	public Boolean isOnline()
	{
		ConnectivityManager cm = (ConnectivityManager) mContext.getSystemService(Context.CONNECTIVITY_SERVICE);
		NetworkInfo netInfo = cm.getActiveNetworkInfo();
		return netInfo != null && netInfo.isConnectedOrConnecting();
	}

	public Boolean isGpsEnable()
	{
		LocationManager lm = (LocationManager) mContext.getSystemService(Context.LOCATION_SERVICE);
		return lm.isProviderEnabled(LocationManager.GPS_PROVIDER);
	}

	public void requestEnableLocation( final Activity context )
	{
		if (googleApiClient == null)
		{
			googleApiClient = new GoogleApiClient.Builder(context)
				.addApi( LocationServices.API)
				.addConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks()
				{
					@Override
					public void onConnected(Bundle bundle)
					{

					}

					@Override
					public void onConnectionSuspended(int i)
					{
						googleApiClient.connect();
					}
				})
				.addOnConnectionFailedListener(new GoogleApiClient.OnConnectionFailedListener()
				{
					@Override
					public void onConnectionFailed(ConnectionResult connectionResult)
					{
						Log.d("Location error","Location error " + connectionResult.getErrorCode());
					}
				}).build();
			googleApiClient.connect();

			LocationRequest locationRequest = LocationRequest.create();
			locationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
			locationRequest.setInterval(30 * 1000);
			locationRequest.setFastestInterval(5 * 1000);
			LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
			builder.setAlwaysShow(true);

			PendingResult<LocationSettingsResult> result = LocationServices.SettingsApi.checkLocationSettings(googleApiClient, builder.build());
			result.setResultCallback(new ResultCallback<LocationSettingsResult>()
			{
				@Override
				public void onResult(LocationSettingsResult result)
				{
					final Status status = result.getStatus();

					switch (status.getStatusCode())
					{
						case LocationSettingsStatusCodes.RESOLUTION_REQUIRED:
							try
							{
								// Show the dialog by calling startResolutionForResult(),
								// and check the result in onActivityResult().
								status.startResolutionForResult(context, REQUEST_LOCATION);
							}
							catch (IntentSender.SendIntentException e)
							{
								// Ignore the error.
							}
							break;
					}
				}
			});
		}
	}
}
