package com.ensoft.medicontrol.infrastructure.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;

import com.app.ensoft.medicontrol.infrastructure.service.IGPSService;
import com.app.ensoft.medicontrol.infrastructure.service.IGPSServiceCallback;
import com.ensoft.medicontrol.infrastructure.event.GPSEvent;

import org.greenrobot.eventbus.EventBus;

public class GPSServiceProvider
{
	protected IGPSService service;
	protected Context context;

	public GPSServiceProvider( Context context )
	{
		this.context = context;

		checkService();
	}

	private ServiceConnection connection = new ServiceConnection()
	{
		@Override public void onServiceConnected(ComponentName className, IBinder service)
		{
			GPSServiceProvider.this.service = IGPSService.Stub.asInterface( service );

			try
			{
				GPSServiceProvider.this.service.registerCallback( serviceCallback );
			}
			catch ( RemoteException e )
			{}
		}

		@Override public void onServiceDisconnected(ComponentName arg0)
		{
			service = null;
		}
	};

	final private IGPSServiceCallback serviceCallback = new IGPSServiceCallback.Stub()
	{
		@Override
		public void onLocationChanged( double latitude, double longitude ) throws RemoteException
		{
			EventBus.getDefault().post( new GPSEvent.onLocationChangeEvent( latitude, longitude ) );
		}
	};

	private void checkService()
	{
		if ( service == null )
		{
			Intent serviceIntent = new Intent( context, GPSService.class );
			context.startService( serviceIntent );
			context.bindService( serviceIntent, connection, 0 );
		}
	}

	public void updateLocation()
	{
		checkService();
		
		try
		{
			if ( null != service )
				service.updateLocation();
		}
		catch ( RemoteException e )
		{}
	}

	public void destroy()
	{
		try
		{
			if ( service != null )
			{
				service.unregisterCallback( serviceCallback );
			}
		}
		catch ( RemoteException e )
		{
			e.printStackTrace();
		}

		context.unbindService( connection );
	}
}
