package com.ensoft.medicontrol.infrastructure.service;

import com.ensoft.medicontrol.BuildConfig;
import com.ensoft.restafari.network.helper.RequestParameters;

import org.json.JSONObject;

public class EndpointService
{
	public static final String BASE_URL = BuildConfig.DEBUG ? "https://aegirsystem.com" : "https://aegirsystem.com";

	public static String fromPath( String path )
	{
		return BASE_URL + path;
	}

	public static String fromPath( String path, JSONObject parameters )
	{
		return fromPath( path + RequestParameters.getUrlQuery( parameters ) );
	}

	public static String fromPath( String path, JSONObject parameters, String idFieldName )
	{
		try
		{
			long id = parameters.getLong( idFieldName );

			if ( !path.endsWith( "/" ) )
			{
				path += "/";
			}

			path += String.valueOf( id );
		}
		catch ( Exception e )
		{
		}

		return fromPath( path + RequestParameters.getUrlQuery( parameters ) );
	}
}
