package com.ensoft.medicontrol.infrastructure.service;

import java.text.DecimalFormat;

public class DistanceService
{
	public static final int DISTANCE_TRIGGER = 70;
	
	public double distance( double lat1, double lon1, double lat2, double lon2 )
	{
		double earthRadius = 6371000; //meters
		double dLat = Math.toRadians(lat2-lat1);
		double dLng = Math.toRadians(lon2-lon1);
		double a = Math.sin(dLat/2) * Math.sin(dLat/2) +
			Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) *
				Math.sin(dLng/2) * Math.sin(dLng/2);
		double c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
		float dist = (float) (earthRadius * c);
		return dist;
	}
	
	public String metersToString( double meters )
	{
		DecimalFormat df = new DecimalFormat( meters > 1000 ? "#.0" : "#" );
		
		if ( meters > 1000 )
		{
			return df.format( meters / 1000 ) + " km";
		}
		
		return df.format( meters ) + " metros";
	}
}
