package com.ensoft.medicontrol.infrastructure.response;

import android.content.Context;

import com.ensoft.medicontrol.domain.model.PatientModel;
import com.ensoft.medicontrol.domain.table.PatientTable;
import com.ensoft.medicontrol.infrastructure.service.VisitService;
import com.ensoft.restafari.network.processor.ResponseProcessor;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

public class VisitEndResponse extends ResponseProcessor<PatientModel>
{
	@Override
	public void handleResponse( Context context, RequestConfiguration request, PatientModel response )
	{
		response.generateFields();
		
		if ( response.visitIsActive() )
			response.getCurrentVisit().generateFields();
		
		new VisitService().endVisits( getNotificationTitle() );
		
		new PatientTable().save( response );
	}
	
	@Override
	public void handleError( Context context, RequestConfiguration request, int errorCode, String errorMessage )
	{
		new VisitService().endVisits( getNotificationTitle() );
	}

	protected String getNotificationTitle()
	{
		return "Visita finalizada manualmente";
	}
}
