package com.ensoft.medicontrol.infrastructure.response;

import android.content.Context;
import android.util.Log;

import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.domain.model.PatientModel;
import com.ensoft.medicontrol.domain.table.PatientTable;
import com.ensoft.medicontrol.domain.table.VisitTable;
import com.ensoft.medicontrol.infrastructure.request.VisitEndRequest;
import com.ensoft.medicontrol.infrastructure.service.VisitService;
import com.ensoft.restafari.network.processor.ResponseProcessor;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

public class PatientsGetResponse extends ResponseProcessor<PatientModel[]>
{
	@Override
	public void handleResponse( Context context, RequestConfiguration request, PatientModel[] response )
	{
		if ( null != response && response.length > 0 )
		{
			PatientTable patientTable = new PatientTable();
			patientTable.truncate();
			
			VisitTable visitTable = new VisitTable();
			
			boolean visitActive = false;
			
			for ( PatientModel patientModel : response )
			{
				patientModel.generateFields();
				
				if ( patientModel.visitIsActive() )
				{
					visitActive = true;
					
					patientModel.getCurrentVisit().generateFields();
					
					if ( patientModel.getCurrentVisit().expired() )
					{
						VisitEndRequest.addRequest();
					}
					else
					{
						new VisitService().endVisits( "Visita finalizada por sistema" );
						
						visitTable.save( patientModel.getCurrentVisit() );
					}
				}
			}
			
			if ( !visitActive )
			{
				visitTable.truncate();
				
				App.getInstance().getNotificationServiceProvider().visitCancel();
			}
			
			patientTable.save( response );
		}
	}
	
	@Override
	public void handleError( Context context, RequestConfiguration request, int errorCode, String errorMessage )
	{
		Log.d( PatientsGetResponse.class.getCanonicalName(), errorMessage );
	}
}
