package com.ensoft.medicontrol.infrastructure.response;

import android.content.Context;

import com.ensoft.medicontrol.domain.table.PatientTable;
import com.ensoft.medicontrol.infrastructure.responseDTO.LocationUpdateDTO;
import com.ensoft.medicontrol.infrastructure.service.VisitService;
import com.ensoft.restafari.network.processor.ResponseProcessor;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

public class LocationUpdateResponse extends ResponseProcessor<LocationUpdateDTO>
{
	@Override
	public void handleResponse( Context context, RequestConfiguration request, LocationUpdateDTO response )
	{
		if ( null != response && null != response.patient )
		{
			response.patient.generateFields();
			
			new VisitService().endVisits( "Visita finalizada por salida de zona" );
			
			new PatientTable().save( response.patient );
		}
	}
}
