package com.ensoft.medicontrol.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.infrastructure.response.VisitStartResponse;
import com.ensoft.medicontrol.infrastructure.responseDTO.VisitStartDTO;
import com.ensoft.medicontrol.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONObject;

import java.util.Map;

public class VisitStartRequest extends BaseAuthorizedRequest
{
	public VisitStartRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.POST, EndpointService.fromPath( "/visita" ), parameters, headers, listener, errorListener );
	}
	
	public static long addRequest( RequestParameters parameters )
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( VisitStartRequest.class, VisitStartResponse.class, VisitStartDTO.class ), parameters );
	}
	
	public static long addRequest( long patientId )
	{
		RequestParameters parameters = new RequestParameters();
		parameters.putLong( "idPaciente", patientId );
		return addRequest( parameters );
	}
}
