package com.ensoft.medicontrol.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.domain.model.PatientModel;
import com.ensoft.medicontrol.infrastructure.response.VisitEndResponse;
import com.ensoft.medicontrol.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONObject;

import java.util.Map;

public class VisitEndRequest extends BaseAuthorizedRequest
{
	public VisitEndRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.POST, EndpointService.fromPath( "/finalizar" ), parameters, headers, listener, errorListener );
	}
	
	public static long addRequest( RequestParameters parameters )
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( VisitEndRequest.class, VisitEndResponse.class, PatientModel.class ), parameters );
	}
	
	public static long addRequest( String observations )
	{
		RequestParameters parameters = new RequestParameters();
		parameters.putString( "observaciones", observations );
		return addRequest( parameters );
	}
	
	public static long addRequest()
	{
		return addRequest( new RequestParameters() );
	}
}
