package com.ensoft.medicontrol.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.domain.model.PatientModel;
import com.ensoft.medicontrol.infrastructure.response.PatientsGetResponse;
import com.ensoft.medicontrol.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Map;

public class PatientsGetRequest extends BaseAuthorizedArrayRequest
{
	public PatientsGetRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONArray> listener, Response.ErrorListener errorListener )
	{
		super( Method.GET, EndpointService.fromPath( "/pacientes" ), parameters, headers, listener, errorListener );
	}

	public static long addRequest()
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( PatientsGetRequest.class, PatientsGetResponse.class, PatientModel[].class ) );
	}
}
