package com.ensoft.medicontrol.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.infrastructure.response.LocationUpdateResponse;
import com.ensoft.medicontrol.infrastructure.responseDTO.LocationUpdateDTO;
import com.ensoft.medicontrol.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONObject;

import java.util.Map;

public class LocationUpdateRequest extends BaseAuthorizedRequest
{
	public LocationUpdateRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.POST, EndpointService.fromPath( "/distancia" ), parameters, headers, listener, errorListener );
	}
	
	public static long addRequest( RequestParameters parameters )
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( LocationUpdateRequest.class, LocationUpdateResponse.class, LocationUpdateDTO.class ), parameters );
	}
	
	public static long addRequest( double lat, double lng )
	{
		RequestParameters parameters = new RequestParameters();
		parameters.putDouble( "latitud", lat );
		parameters.putDouble( "longitud", lng );
		return addRequest( parameters );
	}
	
	public static long addRequest()
	{
		return addRequest( App.getInstance().getPreferencesService().getLatitude(), App.getInstance().getPreferencesService().getLongitude() );
	}
}
