package com.ensoft.medicontrol.domain.table;

import android.content.CursorLoader;
import android.database.Cursor;

import com.ensoft.medicontrol.domain.model.VisitModel;
import com.ensoft.restafari.database.DatabaseTableModel;

public class VisitTable extends DatabaseTableModel<VisitModel>
{
	public VisitTable()
	{
		super( VisitModel.class );
	}
	
	public CursorLoader getLoaderFromProfessional( long professionalId )
	{
		return new CursorLoader( getContext(), getContentUri(), tableColumns.getAll(), "idProfesional = ?", new String[] { String.valueOf( professionalId  ) }, "idProfesional ASC" );
	}
	
	public VisitModel[] getVisits( long professionalId )
	{
		Cursor cursor = getDatabaseResolver().query( getContentUri(), tableColumns.getAll(), "idProfesional = ?", new String[] { String.valueOf( professionalId  ) }, "idPaciente ASC" );
		
		if ( null != cursor )
		{
			VisitModel[] visits = new VisitModel[ cursor.getCount() ];
			
			if ( cursor.moveToFirst() )
			{
				int i = 0;
				
				do
				{
					visits[i] = new VisitModel();
					visits[i].fromCursor( cursor );
					
					i++;
				} while ( cursor.moveToNext() );
				
				cursor.close();
				
				return visits;
			}
			
			cursor.close();
		}
		
		return null;
	}
}
