package com.ensoft.medicontrol.domain.table;

import android.database.Cursor;

import com.ensoft.medicontrol.domain.model.UserModel;
import com.ensoft.restafari.database.DatabaseTableModel;

public class UserTable extends DatabaseTableModel<UserModel>
{
	public UserTable()
	{
		super( UserModel.class );
	}

	public UserModel[] getAll()
	{
		Cursor cursor = getDatabaseResolver().query( getContentUri(), tableColumns.getAll(), null, null, "usuario ASC" );

		if ( null != cursor )
		{
			UserModel[] users = new UserModel[ cursor.getCount() ];

			if ( cursor.moveToFirst() )
			{
				int i = 0;

				do
				{
					users[i] = new UserModel();
					users[i].fromCursor( cursor );

					i++;
				} while ( cursor.moveToNext() );
				
				cursor.close();
				
				return users;
			}

			cursor.close();
		}

		return null;
	}

	public UserModel getFromName( String name )
	{
		Cursor cursor = getDatabaseResolver().query( getContentUri(), tableColumns.getAll(), "user = ? LIMIT 1", new String[] { name }, null );

		if ( null != cursor )
		{
			if ( cursor.moveToFirst() )
			{
				UserModel user = new UserModel();
				user.fromCursor( cursor );
				return user;
			}
		}

		return null;
	}
}
