package com.ensoft.medicontrol.domain.model;

import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.infrastructure.service.DateService;
import com.ensoft.restafari.database.annotations.DbField;
import com.ensoft.restafari.database.annotations.DbPrimaryKey;
import com.google.gson.annotations.SerializedName;

public class VisitModel extends BaseModel
{
	@SerializedName( "idPaciente" )
	@DbField
	protected long patientId;
	
	@SerializedName( "idProfesional" )
	@DbField
	protected long professionalId;
	
	@SerializedName( "idVisita" )
	@DbField
	@DbPrimaryKey
	protected long visitId;
	
	@SerializedName( "inicio" )
	@DbField
	protected String startDatetimeString;
	
	@SerializedName( "duracion" )
	@DbField
	protected String visitLengthString;
	
	@SerializedName( "fin" )
	@DbField
	protected String endDatetimeString;
	
	@SerializedName( "startTimestamp" )
	@DbField
	protected long startTimestamp;
	
	@SerializedName( "length" )
	@DbField
	protected long length;
	
	@SerializedName( "endTimestamp" )
	@DbField
	protected long endTimestamp;
	
	public void generateFields()
	{
		DateService dateService = new DateService();
		
		startTimestamp = dateService.fromStringToTimestamp( startDatetimeString );
		length = dateService.timeToSeconds( visitLengthString );
		endTimestamp = dateService.fromStringToTimestamp( endDatetimeString );
	}
	
	public long getPatientId()
	{
		return patientId;
	}
	
	public long getProfessionalId()
	{
		return professionalId;
	}
	
	public long getVisitId()
	{
		return visitId;
	}
	
	public String getStartDatetimeString()
	{
		return startDatetimeString;
	}
	
	public String getVisitLengthString()
	{
		return visitLengthString;
	}
	
	public long getStartTimestamp()
	{
		return startTimestamp;
	}
	
	public long getStartTimestampFixed()
	{
		return startTimestamp + App.getInstance().getPreferencesService().getServerTimeDiff();
	}
	
	public long getEndTimestampFixed()
	{
		return endTimestamp + App.getInstance().getPreferencesService().getServerTimeDiff();
	}
	
	public long getLength()
	{
		return length;
	}
	
	public String getEndDatetimeString()
	{
		return endDatetimeString;
	}
	
	public long getEndTimestamp()
	{
		return endTimestamp;
	}
	
	@Override
	public long getId()
	{
		return getVisitId();
	}
	
	public boolean expired()
	{
		return new DateService().getCurrentTimestamp() > getEndTimestampFixed();
	}
}
