package com.ensoft.medicontrol.domain.model;

import com.ensoft.medicontrol.App;
import com.ensoft.medicontrol.infrastructure.service.DateService;
import com.ensoft.medicontrol.infrastructure.service.DistanceService;
import com.ensoft.restafari.database.annotations.DbField;
import com.ensoft.restafari.database.annotations.DbPrimaryKey;
import com.google.gson.annotations.SerializedName;

public class PatientModel extends BaseModel
{
	@SerializedName( "idProfesional" )
	@DbField
	protected long professionalId;
	
	@SerializedName( "idPaciente" )
	@DbField
	@DbPrimaryKey
	protected long patientId;
	
	@SerializedName( "hora_sesion" )
	@DbField
	protected int sessionType;
	
	@SerializedName( "duracion_sesion" )
	@DbField
	protected String sessionLengthString;
	
	@SerializedName( "session_length" )
	@DbField
	protected long sessionLength;
	
	@SerializedName( "honorarios" )
	@DbField
	protected long professionalFees;
	
	@SerializedName( "visitasxmes" )
	@DbField
	protected long visitsByMonth;
	
	@SerializedName( "estado" )
	@DbField
	protected long state;
	
	@SerializedName( "creado" )
	@DbField
	protected String createdDateString;
	
	@SerializedName( "modificado" )
	@DbField
	protected String modifiedDateString;
	
	@SerializedName( "created" )
	@DbField
	protected long createdTimestamp;
	
	@SerializedName( "modifiedTimestamp" )
	@DbField
	protected long modifiedTimestamp;
	
	@SerializedName( "telefono" )
	@DbField
	protected String phone;
	
	@SerializedName( "direccion" )
	@DbField
	protected String address;
	
	@SerializedName( "localidad" )
	@DbField
	protected String city;
	
	@SerializedName( "paciente" )
	@DbField
	protected String name;
	
	@SerializedName( "latitud" )
	@DbField
	protected double latitude;
	
	@SerializedName( "longitud" )
	@DbField
	protected double longitude;
	
	@SerializedName( "totalSesiones" )
	@DbField
	protected long totalSessions;
	
	@SerializedName( "sesionesMesActual" )
	@DbField
	protected long currentMonthSessions;
	
	@SerializedName( "visitaActiva" )
	protected VisitModel currentVisit;
	
	public void generateFields()
	{
		DateService dateService = new DateService();
		sessionLength = dateService.timeToSeconds( getSessionLengthString() );
		createdTimestamp = dateService.fromStringToTimestamp( createdDateString );
		modifiedTimestamp = dateService.fromStringToTimestamp( modifiedDateString );
	}
	
	public long getProfessionalId()
	{
		return professionalId;
	}
	
	public long getPatientId()
	{
		return patientId;
	}
	
	public int getSessionType()
	{
		return sessionType;
	}
	
	public String getSessionLengthString()
	{
		return sessionLengthString;
	}
	
	public long getProfessionalFees()
	{
		return professionalFees;
	}
	
	public long getVisitsByMonth()
	{
		return visitsByMonth;
	}
	
	public long getState()
	{
		return state;
	}
	
	public String getCreatedDateString()
	{
		return createdDateString;
	}
	
	public String getModifiedDateString()
	{
		return modifiedDateString;
	}
	
	public String getPhone()
	{
		return phone;
	}
	
	public String getAddress()
	{
		return address;
	}
	
	public String getCity()
	{
		return city;
	}
	
	public String getName()
	{
		return name;
	}
	
	public double getLatitude()
	{
		return latitude;
	}
	
	public double getLongitude()
	{
		return longitude;
	}
	
	public long getTotalSessions()
	{
		return totalSessions;
	}
	
	public long getCurrentMonthSessions()
	{
		return currentMonthSessions;
	}
	
	public long getSessionLength()
	{
		return sessionLength;
	}
	
	public long getCreatedTimestamp()
	{
		return createdTimestamp;
	}
	
	public long getModifiedTimestamp()
	{
		return modifiedTimestamp;
	}
	
	public VisitModel getCurrentVisit()
	{
		return currentVisit;
	}
	
	public boolean visitIsActive()
	{
		return null != getCurrentVisit();
	}
	
	public void setCurrentVisit( VisitModel currentVisit )
	{
		this.currentVisit = currentVisit;
	}
	
	@Override
	public long getId()
	{
		return getPatientId();
	}
	
	public double getDistanceToUser()
	{
		double distance = 0;
		
		if ( 0 != App.getInstance().getPreferencesService().getLatitude() && 0 != getLatitude() )
		{
			try
			{
				Double lat1 = App.getInstance().getPreferencesService().getLatitude();
				Double lng1 = App.getInstance().getPreferencesService().getLongitude();
				Double lat2 = getLatitude();
				Double lng2 = getLongitude();
				
				distance = new DistanceService().distance( lat1, lng1, lat2, lng2 );
			}
			catch( Exception e )
			{
			}
		}
		
		return distance;
	}
}
