package com.ensoft.medicontrol.domain.model;

import android.location.Location;

import com.ensoft.restafari.database.annotations.DbField;
import com.ensoft.restafari.database.annotations.DbPrimaryKey;
import com.google.gson.annotations.SerializedName;

public class LocationModel extends BaseModel
{
	@SerializedName( "professionalId" )
	@DbField
	@DbPrimaryKey
	protected long professionalId;
	
	@SerializedName( "latitude" )
	@DbField
	protected double latitude;
	
	@SerializedName( "longitude" )
	@DbField
	protected double longitude;
	
	public LocationModel()
	{
	}
	
	public LocationModel( long professionalId, double latitude, double longitude )
	{
		this.professionalId = professionalId;
		this.latitude = latitude;
		this.longitude = longitude;
	}
	
	public LocationModel( long professionalId, Location location )
	{
		this( professionalId, location.getLatitude(), location.getLongitude() );
	}
	
	public long getProfessionalId()
	{
		return professionalId;
	}
	
	public double getLatitude()
	{
		return latitude;
	}
	
	public double getLongitude()
	{
		return longitude;
	}
	
	@Override
	public long getId()
	{
		return getProfessionalId();
	}
}
