package com.ensoft.medicontrol;

import android.content.Context;
import android.util.Log;

import com.ensoft.medicontrol.domain.table.LocationTable;
import com.ensoft.medicontrol.domain.table.PatientTable;
import com.ensoft.medicontrol.domain.table.UserTable;
import com.ensoft.medicontrol.domain.table.VisitTable;
import com.ensoft.medicontrol.infrastructure.response.ResponseManager;
import com.ensoft.medicontrol.infrastructure.service.GPSServiceProvider;
import com.ensoft.medicontrol.infrastructure.service.NotificationServiceProvider;
import com.ensoft.medicontrol.infrastructure.service.preference.PreferencesService;
import com.ensoft.restafari.database.DatabaseService;
import com.ensoft.restafari.database.TableCollection;
import com.ensoft.restafari.network.service.RequestService;
import com.ensoft.restafari.network.service.RequestServiceOptions;

import org.acra.ACRA;
import org.acra.annotation.ReportsCrashes;

@ReportsCrashes(
	formUri = "http://medicontrol.ensoft-dev.com/"
)
public class App extends android.support.multidex.MultiDexApplication
{
	public static final String TAG = App.class.getCanonicalName();
	public static App instance;
	protected PreferencesService preferencesService;
	protected ResponseManager responseManager;
	protected GPSServiceProvider gpsServiceProvider;
	protected NotificationServiceProvider notificationServiceProvider;

	public static App getInstance()
	{
		return instance;
	}

	@Override
	protected void attachBaseContext( Context base )
	{
		super.attachBaseContext( base );
		
		ACRA.init( this );
		
		TableCollection tableCollection = new TableCollection( "AegirSystemDbV0001", 1 );
		tableCollection.add( new UserTable() );
		tableCollection.add( new PatientTable() );
		tableCollection.add( new VisitTable() );
		tableCollection.add( new LocationTable() );
		DatabaseService.init( this, tableCollection );
		
		Log.w( TAG, "Application Initialized" );
	}

	@Override
	public void onCreate()
	{
		super.onCreate();

		instance = this;

		preferencesService = new PreferencesService( this );

		responseManager = new ResponseManager();

		RequestServiceOptions requestServiceOptions = new RequestServiceOptions.Builder().
			setProxyHost( getPreferencesService().getProxyHost() ).
			setProxyPort( getPreferencesService().getProxyPort() ).
			setUnsafeConversions( false ).
			build();

		RequestService.init( this, requestServiceOptions );

		notificationServiceProvider = new NotificationServiceProvider( this );
	}

	public PreferencesService getPreferencesService()
	{
		return preferencesService;
	}

	public ResponseManager getResponseManager()
	{
		return responseManager;
	}

	public RequestService getRequestService()
	{
		return RequestService.getInstance();
	}

	public GPSServiceProvider getGPSServiceProvider()
	{
		if ( null == gpsServiceProvider )
			gpsServiceProvider = new GPSServiceProvider( this );
		
		return gpsServiceProvider;
	}

	public NotificationServiceProvider getNotificationServiceProvider()
	{
		return notificationServiceProvider;
	}
}
