package com.ensoft.ace.view.holder;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.PatientCardFile;

public class PatientCardFileHolder extends BaseHolder<PatientCardFile>
{
	private TextView name;
	private TextView date;

	public PatientCardFileHolder( View view )
	{
		super( view );

		name = (TextView)view.findViewById( R.id.item_name );
		date = (TextView)view.findViewById( R.id.item_date );
	}

	@Override
	public void setData( Context context, PatientCardFile patientCardFile )
	{
		name.setText( patientCardFile.fullName );
		date.setText( patientCardFile.dateFormated );
	}
}
