package com.ensoft.ace.view.holder;

import android.content.Context;
import android.view.View;

public abstract class BaseHolder<Model>
{
	public static class PositionData
	{
		int total;
		int position;

		public PositionData( int position, int total )
		{
			this.position = position;
			this.total = total;
		}

		public boolean isFirst()
		{
			return 0 == position;
		}

		public boolean isLast()
		{
			return total - 1 == position;
		}
	}

	public PositionData positionData;

	BaseHolder( View view )
	{}

	abstract public void setData( Context context, Model model );
}
