package com.ensoft.ace.view.export;

import android.app.Activity;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.askjeffreyliu.floydsteinbergdithering.Utils;
import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.Flowmetry;
import com.ensoft.ace.domain.model.PatientCard;
import com.ensoft.ace.infrastructure.service.BitmapService;
import com.ensoft.ace.infrastructure.service.BluetoothPrinterSocketConnexion;
import com.ensoft.ace.infrastructure.service.BluetoothPrinters;
import com.ensoft.ace.infrastructure.service.EscPosPrinter;
import com.ensoft.ace.infrastructure.service.EscPosStudyBuilder;
import com.ensoft.ace.infrastructure.service.GraphPrinterService;
import com.ensoft.ace.infrastructure.service.LiverpoolNomogramService;
import com.ensoft.ace.view.activity.BaseActivity;
import com.jjoe64.graphview.GraphView;

import org.apache.commons.text.WordUtils;


public class FlowmetryEscPos
{
	protected Activity activity;
	protected Flowmetry flowmetry;
	protected GraphView graphView = null;
	private PatientCard patientCard;
	private String report;
	private int numPages;
	private BluetoothPrinterSocketConnexion bluetoothPrinterSocketConnexion;
	private EscPosPrinter printer;
	private final int maxLength = 45;

	public FlowmetryEscPos( Activity activity, Flowmetry flowmetry, PatientCard patientCard, String report, int numPages )
	{
		this.activity = activity;
		this.flowmetry = flowmetry;
		this.patientCard = patientCard;
		this.report = report;
		this.numPages = numPages;

		if ( !flowmetry.foundResults() )
			flowmetry.findResults();

		bluetoothPrinterSocketConnexion = BluetoothPrinters.selectFirstPairedBluetoothPrinter();

		if ( null == bluetoothPrinterSocketConnexion)
		{
			( ( BaseActivity )activity ).errorMessage( activity.getString( R.string.bt_printer_connection_error ) );
			return;
		}

		printer = new EscPosPrinter( bluetoothPrinterSocketConnexion, 203, 48f, maxLength);

		GraphPrinterService.drawFlowmetryGraph( activity, flowmetry, this::printView );
	}

	private String buildFormattedStudy( int maxLength )
	{
		EscPosStudyBuilder study = new EscPosStudyBuilder();
		study.addTitleTextLine( "Resultados:" );
		study.addBoldTextLine( "Uroflujometría:" );
		study.addTextLine( "Q Máximo:", flowmetry.getQMax(), "ml/s" );
		study.addTextLine( "Volumen Total:", flowmetry.getTotalVol(), "ml" );
		study.addTextLine( "Volumen hasta Q Max:", flowmetry.getVolAtQMaxTime(), "ml" );
		study.addTextLine( "Q Promedio:", flowmetry.getQAverage(), "ml/s" );
		study.addTextLine( "Tiempo Total:", flowmetry.getTotalTime(), "seg" );
		study.addTextLine( "Q a 2 seg:", flowmetry.getQAt2Seconds(), "ml/s" );
		study.addTextLine( "Tiempo Neto:", flowmetry.getNetTime(), "seg" );
		study.addTextLine( "T a QMax:", flowmetry.getQMaxTime(), "seg" );
		study.addTextLine( "Tiempo de descenso:", flowmetry.getTotalDescTime(), "seg" );
		study.addTextLine( "Tiempo entre pausas:", flowmetry.getTimePaused(), "seg" );
		study.addBoldTextLine( "Datos del Paciente:" );
		study.addTextLine( "Nombre:", patientCard.getFullName() );
		study.addTextLine( "Ciudad:", patientCard.getCity() );
		study.addTextLine( "Teléfono:", patientCard.getPhoneNumber() );
		study.addTextLine( "Mutual:", patientCard.getMedicalInsurance() );
		study.addTextLine( "Edad:", patientCard.getAge() );
		study.addTextLine( "Sexo:", patientCard.getGender() );
		study.addBoldTextLine( "Informe:" );
		String reportWrapped = WordUtils.wrap( report, maxLength );
		for ( String line : reportWrapped.split( "\n" ) )
		{
			study.addTextLine( line );
		}
		study.addBoldTextLine( "Datos del Estudio:" );
		study.addTextLine( "Fecha:", patientCard.getFullDateString() );
		study.addBoldTextLine( "Observaciones:" );
		reportWrapped = WordUtils.wrap( patientCard.getObservations(), maxLength );
		for ( String line : reportWrapped.split( "\n" ) )
		{
			study.addTextLine( line );
		}
		return study.getStudy();
	}

	private void printView( View graphLayout )
	{
		Bitmap bitmap = Utils.floydSteinbergDithering( BitmapService.getBitmapFromView( graphLayout ) );
		drawBitmap( bitmap );

		( (ViewGroup) graphLayout.getParent() ).removeView( graphLayout );

		printer.printFormattedText( buildFormattedStudy( maxLength ) );

		if ( numPages > 1 )
		{
			GraphPrinterService.drawLiverpoolGraph( activity, flowmetry, LinearLayout.VERTICAL, patientCard, this::printLiverpool );
		}
		else
		{
			printer.disconnectPrinter();
		}
	}

	private void drawBitmap( Bitmap bitmap )
	{
		int colH = bitmap.getHeight()/5;
		int cols = bitmap.getHeight()/colH;
		for ( int i = 0; i < cols; i++ )
		{
			Bitmap bitmapCrop = Bitmap.createBitmap( bitmap, 0, i * colH, bitmap.getWidth(), colH );
			bluetoothPrinterSocketConnexion.printImage( bitmapCrop );
		}

	}

	private void printLiverpool( View graphLayout, LiverpoolNomogramService liverpoolNomogramService )
	{
		Bitmap bmp = Utils.floydSteinbergDithering( BitmapService.getBitmapFromView( liverpoolNomogramService.getVolMaxGraph() ) );
		Bitmap bmp2 = Utils.floydSteinbergDithering( BitmapService.getBitmapFromView( liverpoolNomogramService.getAverageGraph() ) );
		drawBitmap( bmp );
		drawBitmap( bmp2 );
		( (ViewGroup) graphLayout.getParent() ).removeView( graphLayout );
		printer.addNewLine();
		printer.addNewLine();
		printer.addNewLine();
		printer.disconnectPrinter();
	}
}
