package com.ensoft.ace.view.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;

import com.ensoft.ace.domain.model.BaseItem;
import com.ensoft.ace.view.holder.BaseHolder;

import java.lang.reflect.Constructor;

public class HolderAdapter<T extends BaseItem> extends BaseAdapter
{
	protected Context context;
	protected LayoutInflater inflater;
	protected T[] items;
	protected int layout;
	protected Class<? extends BaseHolder> holderClass;

	public HolderAdapter( Context context, int layout, T[] items, Class<? extends BaseHolder> holderClass )
	{
		this.context = context;
		this.layout = layout;
		this.items = items;
		this.inflater = LayoutInflater.from( context );
		this.holderClass = holderClass;
	}

	public T[] getItems()
	{
		return items;
	}

	@Override
	public int getCount()
	{
		return null != items ? items.length : 0;
	}

	@Override
	public Object getItem( int position )
	{
		return null != items && position < items.length ? items[ position ] : null;
	}

	@Override
	public long getItemId( int position )
	{
		if ( null != items && position < items.length )
		{
			T item = items[ position ];

			if ( null != item )
			{
				long id = item.getPrimaryKeyValue();

				if ( 0 == id )
				{
					return position;
				}

				return id;
			}
		}

		return -1;
	}

	@Override
	public View getView( int position, View view, ViewGroup parent )
	{
		BaseHolder<T> holder = null;

		if ( view != null )
		{
			holder = (BaseHolder) view.getTag();
		}
		else
		{
			view = inflater.inflate( layout, parent, false);

			try
			{
				Constructor<?> constructor = holderClass.getConstructor( View.class );

				holder = (BaseHolder<T>)constructor.newInstance( view );

				view.setTag( holder );
			}
			catch ( Exception exception )
			{
			}
		}

		if ( holder != null )
		{
			holder.positionData = new BaseHolder.PositionData( position, null != items ? items.length : 0 );
			holder.setData( context, items[ position ] );
		}

		return view;
	}
}
