package com.ensoft.ace.view.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.service.survey.Survey;
import com.ensoft.ace.domain.service.survey.SurveyQuestion;

import java.util.ArrayList;

public class SurveyIPSSActivity extends BaseActivity
{
	Survey<Integer> survey;
	int currentQuestion;

	private ListView.OnItemClickListener itemClickListener = new AdapterView.OnItemClickListener()
	{
		@Override
		public void onItemClick( AdapterView<?> parent, View view, int position, long id )
		{
			survey.GetQuestion( currentQuestion ).setPositionSelected( position );
		}
	};

	private View.OnClickListener onClickListener = new View.OnClickListener()
	{
		@Override
		public void onClick( final View v )
		{
			switch ( v.getId() )
			{
				case R.id.btnPreviousQuestion:
					loadQuestion( currentQuestion - 1 );
					break;
				case R.id.btnNextQuestion:
					loadQuestion( currentQuestion + 1 );
					break;
				case R.id.btnScores:
					showResults();
					break;
			}
		}
	};

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_survey_ipss );

		Button button = (Button) this.findViewById( R.id.btnNextQuestion );
		button.setOnClickListener( onClickListener );

		button = (Button) this.findViewById( R.id.btnPreviousQuestion );
		button.setOnClickListener( onClickListener );

		button = (Button) this.findViewById( R.id.btnScores );
		button.setOnClickListener( onClickListener );

		ListView listView = (ListView) this.findViewById( R.id.listViewQuestions );
		listView.setOnItemClickListener( itemClickListener );

		survey = new Survey<>();
		addQuestions();
		setAnswers();
		loadQuestion( 0 );
	}

	private void setAnswers()
	{
		Intent intent = getIntent();
		ArrayList<Integer> answers = intent.getIntegerArrayListExtra( "surveyIPSS" );
		if ( answers != null )
		{
			survey.SetAnswers( answers, -1 );
		}
	}

	private void loadQuestion( int i )
	{
		currentQuestion = i;
		SurveyQuestion<Integer> question = survey.GetQuestion( i );

		TextView questionType = (TextView) this.findViewById( R.id.lblQuestionType );
		questionType.setText( question.getQuestionType() );

		TextView questionDescription = (TextView) this.findViewById( R.id.lblQuestionDescription );
		questionDescription.setText( question.getDescription() );

		ListView listView = (ListView) this.findViewById( R.id.listViewQuestions );
		listView.setChoiceMode( ListView.CHOICE_MODE_SINGLE );
		listView.setAdapter( new ArrayAdapter<>( this, android.R.layout.simple_list_item_single_choice, question.optionsText ) );
		if ( question.isSelected() )
		{
			listView.setItemChecked( question.getOptionSelectedPosition(), true );
//            listView.smoothScrollToPosition(question.getOptionSelectedPosition());
			listView.setSelection( question.getOptionSelectedPosition() );
		}

		Button button = (Button) this.findViewById( R.id.btnNextQuestion );
		button.setEnabled( !survey.IsLastQuestion( i ) );

		button = (Button) this.findViewById( R.id.btnPreviousQuestion );
		button.setEnabled( i > 0 );
	}

	private void showResults()
	{
		// 1. Instantiate an AlertDialog.Builder with its constructor
		AlertDialog.Builder builder = new AlertDialog.Builder( this );
		// 2. Chain together various setter methods to set the dialog characteristics
		int scoreIPSS = 0;
		int scoreVida = 0;
		int unanswered = 0;
		for ( int i = 0; i < survey.GetQuestionCount(); i++ )
		{
			SurveyQuestion<Integer> question = survey.GetQuestion( i );
			if ( question.isSelected() )
			{
				if ( question.getGroupIndex() == 0 )
				{
					scoreIPSS += question.getOptionSelected();
				}
				else
				{
					scoreVida += question.getOptionSelected();
				}
			}
			else
			{
				unanswered++;
			}
		}

		builder.setMessage( String.format( "IPSS: %s - Indice Vida: %s %nSin responder: %s", scoreIPSS, scoreVida, unanswered ) )
				.setTitle( "Resultados" );
		// 3. Get the AlertDialog from create()
		AlertDialog dialog = builder.create();
		dialog.show();
	}

	private void addQuestions()
	{
		int groupIndex = 0;
		SurveyQuestion<Integer> surveyQuestion = survey.AddQuestion( "Vaciamiento Incompleto", "Durante el último mes: ¿Cuántas veces ha tenido la sensación de no haber vaciado completamente su vejiga después de orinar?", groupIndex );
		addDefaultOptions( surveyQuestion );

		surveyQuestion = survey.AddQuestion( "Frecuencia", "Durante el último mes: ¿Cuántas veces debió orinar nuevamente antes de las dos horas?", groupIndex );
		addDefaultOptions( surveyQuestion );

		surveyQuestion = survey.AddQuestion( "Intermitencia", "Durante el último mes: ¿Cuántas veces notó que su chorro de orina se detenía y comenzaba nuevamente?", groupIndex );
		addDefaultOptions( surveyQuestion );

		surveyQuestion = survey.AddQuestion( "Urgencia", "Durante el último mes: ¿Cuántas veces le resultó dificil controlar el deseo de orinar?", groupIndex );
		addDefaultOptions( surveyQuestion );

		surveyQuestion = survey.AddQuestion( "Chorro Débil", "Durante el último mes: ¿Cuántas veces ha notado que su chorro de orina es débil o sin fuerza?", groupIndex );
		addDefaultOptions( surveyQuestion );

		surveyQuestion = survey.AddQuestion( "Esfuerzo", "Durante el último mes: ¿Cuántas veces tuvo que esforzarse para orinar?", groupIndex );
		addDefaultOptions( surveyQuestion );

		surveyQuestion = survey.AddQuestion( "Nocturia", "Durante el último mes: ¿Cuántas veces ha orinado desde que se acostó por la noche hasta que se levantó por la mañana?", groupIndex );
		surveyQuestion.addOption( "Ninguna vez", 0 );
		surveyQuestion.addOption( "1 vez", 1 );
		surveyQuestion.addOption( "2 veces", 2 );
		surveyQuestion.addOption( "3 veces", 3 );
		surveyQuestion.addOption( "4 veces", 4 );
		surveyQuestion.addOption( "5 o más", 5 );

		groupIndex++;

		surveyQuestion = survey.AddQuestion( "Calidad de Vida relacionada a los síntomas miccionales", "¿Si tuviera que orinar el resto de su vida como lo hace ahora, cómo se sentiría?", groupIndex );
		surveyQuestion.addOption( "Encantado", 0 );
		surveyQuestion.addOption( "Agradable", 1 );
		surveyQuestion.addOption( "Satisfecho", 2 );
		surveyQuestion.addOption( "+/- Satisfecho", 3 );
		surveyQuestion.addOption( "Insatisfecho", 4 );
		surveyQuestion.addOption( "Infeliz", 5 );
		surveyQuestion.addOption( "Terrible", 6 );
	}

	private void addDefaultOptions( SurveyQuestion<Integer> surveyQuestion )
	{
		surveyQuestion.addOption( "Ninguna", 0 );
		surveyQuestion.addOption( "Menos de 1 vez cada 5 veces", 1 );
		surveyQuestion.addOption( "Menos de la mitad de las veces", 2 );
		surveyQuestion.addOption( "La mitad de las veces", 3 );
		surveyQuestion.addOption( "Más de la mitad de las veces", 4 );
		surveyQuestion.addOption( "Casi siempre", 5 );
	}

	@Override
	public void finish()
	{
		Intent resultIntent = new Intent();
		ArrayList<Integer> answers = survey.GetAnswers( -1 );
		int sinResponder = 0;
		for ( Integer answer : answers )
		{
			if ( answer == -1 )
			{
				sinResponder++;
			}
		}
		resultIntent.putExtra( "surveyIPSS", answers );
		if ( sinResponder != 0 )
		{
			Toast.makeText( getBaseContext(), "Hay " + sinResponder + " pregunta(s) sin responder", Toast.LENGTH_LONG ).show();
		}
		else
		{
			Toast.makeText( getBaseContext(), "Cuestionario completo", Toast.LENGTH_LONG ).show();
		}
		setResult( Activity.RESULT_OK, resultIntent );
		super.finish();
	}
}
