package com.ensoft.ace.view.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.PatientCardFile;
import com.ensoft.ace.infrastructure.service.EmailService;

import java.io.File;

public class StudySearchResultSendActivity extends StudySearchResultActivity
{
	public static void newInstance( Context context, String name, String dateStart, String dateEnd )
	{
		Intent intent = new Intent( context, StudySearchResultSendActivity.class );

		intent.putExtra( NAME_PARAM, name );
		intent.putExtra( START_DATE_PARAM, dateStart );
		intent.putExtra( END_DATE_PARAM, dateEnd );

		context.startActivity( intent );
	}

	@Override
	protected void onPostCreate( @Nullable Bundle savedInstanceState )
	{
		super.onPostCreate( savedInstanceState );
		setTitle( R.string.send_study );
	}

	@Override
	protected void onItemClick( int position )
	{
		PatientCardFile patientCardFile = adapter.getCard( position );
		String chosenDir = patientCardFile.path;

		File file = new File( chosenDir );

		if ( file.isFile() && ( file.getPath().endsWith( ".ace" ) || file.getPath().endsWith( ".flj" ) ) )
			new EmailService().sendFlowmetryFileByMail( this, chosenDir );
	}
}
