package com.ensoft.ace.view.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.PatientCardFile;

import java.io.File;

public class StudySearchResultDeleteActivity extends StudySearchResultActivity
{
	public static void newInstance( Context context, String name, String dateStart, String dateEnd )
	{
		Intent intent = new Intent( context, StudySearchResultDeleteActivity.class );

		intent.putExtra( NAME_PARAM, name );
		intent.putExtra( START_DATE_PARAM, dateStart );
		intent.putExtra( END_DATE_PARAM, dateEnd );

		context.startActivity( intent );
	}

	@Override
	protected void onPostCreate( @Nullable Bundle savedInstanceState )
	{
		super.onPostCreate( savedInstanceState );
		setTitle( R.string.delete_study );
	}

	@Override
	protected int getItemLayout()
	{
		return R.layout.item_delete_result;
	}

	@Override
	protected void onItemClick( int position )
	{
		final PatientCardFile patientCardFile = adapter.getCard( position );

		new MaterialDialog.Builder(this)
			.title(R.string.app_name)
			.content( getString( R.string.sure_erase, patientCardFile.fullName ) )
			.positiveText(R.string.erase)
			.negativeText(R.string.cancel)
			.onPositive( ( dialog, which ) -> {
				File file = new File( patientCardFile.path );

				if ( file.exists() )
					file.delete();

				loadStudies();
			} )
			.show();
	}
}
