package com.ensoft.ace.view.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.PatientCardFile;
import com.ensoft.ace.infrastructure.service.DateService;
import com.ensoft.ace.infrastructure.service.PatientCardFileService;
import com.ensoft.ace.view.adapter.SearchResultAdapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnItemClick;

public class StudySearchResultActivity extends BaseActivity
{
	public static String NAME_PARAM = "name";
	public static String START_DATE_PARAM = "startDate";
	public static String END_DATE_PARAM = "endDate";

	@BindView( R.id.loading )
	protected ProgressBar loader;

	@BindView( R.id.search_result_listview )
	protected ListView listView;

	@BindView( R.id.no_result_text )
	protected TextView noResultText;

	protected SearchResultAdapter adapter;

	public static void newInstance( Context context, String name, String dateStart, String dateEnd )
	{
		Intent intent = new Intent( context, StudySearchResultActivity.class );

		intent.putExtra( NAME_PARAM, name );
		intent.putExtra( START_DATE_PARAM, dateStart );
		intent.putExtra( END_DATE_PARAM, dateEnd );

		context.startActivity( intent );
	}

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		setContentView( R.layout.activity_study_search_result );

		ButterKnife.bind( this );
	}

	@Override
	protected void onPostCreate( @Nullable Bundle savedInstanceState )
	{
		super.onPostCreate( savedInstanceState );

		setTitle( R.string.search_results );

		listView.setVisibility( View.GONE );

		loadStudies();
	}

	protected void setNoResults()
	{
		noResultText.setVisibility( View.VISIBLE );
		loader.setVisibility( View.GONE );
	}

	protected void loadStudies()
	{
		if ( null != getIntent() && null != getIntent().getExtras() )
		{
			Bundle data = getIntent().getExtras();
			loadStudies( data.getString( NAME_PARAM ), data.getString( START_DATE_PARAM ), data.getString( END_DATE_PARAM ) );
		}
	}

	protected void loadStudies( String name, String startDate, String endDate )
	{
		List<PatientCardFile> patients = new PatientCardFileService().getStudies();

		if ( patients.size() > 0 )
		{
			List<PatientCardFile> patientsRemove = new ArrayList<>();

			name = name.toLowerCase();

			if ( name.length() > 0 )
			{
				for ( PatientCardFile card : patients )
				{
					if ( !card.fullName.toLowerCase().contains( name ) )
					{
						patientsRemove.add( card );
					}
				}
			}

			DateService dateService = new DateService();
			Date start = dateService.fromString( startDate );
			Date end = dateService.fromString( endDate );

			if ( start != null && end != null )
			{
				long startEpoch = start.getTime();

				long endEpoch = end.getTime();

				for ( PatientCardFile card : patients )
				{
					if ( !( card.epoch >= startEpoch && card.epoch <= endEpoch ) )
					{
						patientsRemove.add( card );
					}
				}
			}
			else if ( start != null )
			{
				long startEpoch = start.getTime();

				for ( PatientCardFile card : patients )
				{
					if ( card.epoch > startEpoch )
					{
						patientsRemove.add( card );
					}
				}
			}

			if ( patientsRemove.size() > 0 )
			{
				for ( PatientCardFile patient : patientsRemove )
				{
					patients.remove( patient );
				}
			}

			if ( patients.size() > 0 )
			{
				Collections.sort(patients, ( pc1, pc2 ) -> pc1.epoch > pc2.epoch ? -1 : 1 );
			}

			if ( patients.size() > 0 )
			{
				adapter = new SearchResultAdapter( this, getItemLayout(), patients.toArray( new PatientCardFile[patients.size()] ) );

				listView.setVisibility( View.VISIBLE );
				listView.setAdapter( adapter );
				loader.setVisibility( View.GONE );
			}
			else
			{
				setNoResults();
			}
		}
		else
		{
			setNoResults();
		}
	}

	protected int getItemLayout()
	{
		return R.layout.item_search_result;
	}

	@OnItemClick( R.id.search_result_listview )
	protected void onItemClick( int position )
	{
		PatientCardFile patientCardFile = adapter.getCard( position );

		Intent intent = new Intent( this, FlowmetryResultActivity.class );
		intent.putExtra( "chosenDir", patientCardFile.path );
		startActivity( intent );
	}
}