package com.ensoft.ace.view.activity;

import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;

import com.ensoft.ace.R;
import com.ensoft.ace.infrastructure.service.DateService;

import java.util.Calendar;
import java.util.Date;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class StudySearchActivity extends BaseActivity
{
	public static final String SEARCH_PARAM = "searchType";

	enum SearchType
	{
		Load,
		Delete,
		Send
	}

	@BindView( R.id.name_search )
	protected EditText patientName;

	@BindView( R.id.start_date_text )
	protected TextView startDateText;

	@BindView( R.id.end_date_text )
	protected TextView endDateText;

	protected SearchType searchType;
	protected String startDate;
	protected String endDate;

	public static void newInstance(  Context context, SearchType searchType )
	{
		Intent activity = new Intent( context, StudySearchActivity.class );
		activity.putExtra( SEARCH_PARAM, searchType.ordinal() );
		context.startActivity( activity );
	}

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		setContentView( R.layout.activity_study_search );

		ButterKnife.bind( this );
	}

	@Override
	protected void onPostCreate(@Nullable Bundle savedInstanceState)
	{
		super.onPostCreate( savedInstanceState );

		if ( getIntent() != null && getIntent().getExtras() != null )
		{
			searchType = SearchType.values()[ getIntent().getExtras().getInt( SEARCH_PARAM, SearchType.Load.ordinal() ) ];
		}

		setTitle( R.string.search_study );

		endDate = new DateService().getDateString( setDate( endDateText, Calendar.getInstance().getTime() ) );

		Calendar calendar = Calendar.getInstance();
		calendar.add( Calendar.YEAR, -1 );
		startDate = new DateService().getDateString( setDate( startDateText, calendar.getTime() ) );
	}

	@OnClick( R.id.start_date_container )
	protected void onStartDateClick(View view)
	{
		Calendar c = Calendar.getInstance();

		new DatePickerDialog( this, ( view1, year, monthOfYear, dayOfMonth ) -> startDate = new DateService().getDateString( setDate( startDateText, year, monthOfYear, dayOfMonth ) ), c.get(Calendar.YEAR ), c.get(Calendar.MONTH ), c.get(Calendar.DAY_OF_MONTH ) ).show();
	}

	@OnClick( R.id.end_date_container )
	protected void onEndDateClick(View view)
	{
		Calendar c = Calendar.getInstance();

		new DatePickerDialog( this, ( view1, year, monthOfYear, dayOfMonth ) -> endDate = new DateService().getDateString( setDate( endDateText, year, monthOfYear, dayOfMonth ) ), c.get(Calendar.YEAR ), c.get(Calendar.MONTH ), c.get(Calendar.DAY_OF_MONTH ) ).show();
	}

	protected Date setDate( TextView textView, int year, int monthOfYear, int dayOfMonth )
	{
		Calendar c = Calendar.getInstance();
		c.set( Calendar.YEAR, year );
		c.set( Calendar.MONTH, monthOfYear );
		c.set( Calendar.DAY_OF_MONTH, dayOfMonth );

		setDate( textView, c.getTime() );

		return c.getTime();
	}

	protected Date setDate( TextView textView, Date date )
	{
		textView.setText( new DateService().getDateFormattedString( date ) );

		return date;
	}

	@OnClick( R.id.submit_button )
	protected void onSearchClick( View view )
	{
		if ( searchType == SearchType.Load )
		{
			StudySearchResultActivity.newInstance( this, patientName.getText().toString(), startDate, endDate );
		}
		else if ( searchType == SearchType.Send )
		{
			StudySearchResultSendActivity.newInstance( this, patientName.getText().toString(), startDate, endDate );
		}
		else if ( searchType == SearchType.Delete )
		{
			StudySearchResultDeleteActivity.newInstance( this, patientName.getText().toString(), startDate, endDate );
		}
	}
}
