package com.ensoft.ace.view.activity;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.appcompat.app.AppCompatActivity;

import com.ensoft.ace.R;

public class SplashActivity extends AppCompatActivity
{
	public static int REQUEST_WRITE_EXTERNAL_STORAGE_PERMISSION = 0x0F3124;
	public static int REQUEST_GET_ACCOUNTS_PERMISSION = 0x0F3125;
	public static int REQUEST_BLUETOOTH_PERMISSION = 0x0F3126;
	public static int welcomeScreenDisplay = 1000;

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		setContentView( R.layout.activity_splash );

		checkPermissions();
	}
	
	public boolean askExternalStorageAccess()
	{
		if ( ContextCompat.checkSelfPermission( this, Manifest.permission.WRITE_EXTERNAL_STORAGE ) != PackageManager.PERMISSION_GRANTED )
		{
			if ( Build.VERSION.SDK_INT >= Build.VERSION_CODES.M )
			{
				requestPermissions( new String[]{ android.Manifest.permission.WRITE_EXTERNAL_STORAGE }, REQUEST_WRITE_EXTERNAL_STORAGE_PERMISSION );
				return true;
			}
		}
		
		return false;
	}
	
	public boolean askAccountsPermissions()
	{
		if ( ContextCompat.checkSelfPermission( this, Manifest.permission.GET_ACCOUNTS ) != PackageManager.PERMISSION_GRANTED )
		{
			if ( Build.VERSION.SDK_INT >= Build.VERSION_CODES.M )
			{
				requestPermissions( new String[]{ android.Manifest.permission.GET_ACCOUNTS }, REQUEST_GET_ACCOUNTS_PERMISSION );
				return true;
			}
		}
		
		return false;
	}

	public boolean askBluetoothPermissions()
	{
		if ( Build.VERSION.SDK_INT >= Build.VERSION_CODES.S )
		{
			if ( ContextCompat.checkSelfPermission( this, Manifest.permission.BLUETOOTH_CONNECT ) != PackageManager.PERMISSION_GRANTED )
			{
				requestPermissions( new String[]{ android.Manifest.permission.BLUETOOTH_CONNECT }, REQUEST_BLUETOOTH_PERMISSION );
				return true;
			}
		}

		return false;
	}

	public void checkPermissions()
	{
		if ( !askExternalStorageAccess() )
		{
			if ( !askAccountsPermissions() )
			{
				if ( !askBluetoothPermissions() )
				{
					startTimeoutToMain();
				}
			}
		}
	}

	@Override
	public void onRequestPermissionsResult( final int requestCode, @NonNull final String[] permissions, @NonNull final int[] grantResults )
	{
		super.onRequestPermissionsResult( requestCode, permissions, grantResults );
		
		checkPermissions();
	}

	protected void startTimeoutToMain()
	{
		new Handler().postDelayed( () -> {
			startActivity( new Intent( SplashActivity.this, MainActivity.class ) );

			finish();
		}, welcomeScreenDisplay );
	}
}
