package com.ensoft.ace.view.activity;

import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceFragment;

import com.ensoft.ace.R;
import com.ensoft.ace.infrastructure.service.PreferenceService;

public class PreferencesActivity extends PreferenceActivity
{
	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		getFragmentManager().beginTransaction().replace( android.R.id.content, new MyPreferenceFragment() ).commit();
	}

	public static class MyPreferenceFragment extends PreferenceFragment
	{
		@Override
		public void onCreate( final Bundle savedInstanceState )
		{
			super.onCreate( savedInstanceState );
			addPreferencesFromResource( R.xml.preferences );

			PreferenceService preferenceService = new PreferenceService();

			final CheckBoxPreference showBattery = (CheckBoxPreference) findPreference( "showBattery" );
			showBattery.setChecked( preferenceService.getShowBattery() );
			showBattery.setOnPreferenceChangeListener( ( preference, newValue ) ->
			{
				preferenceService.setShowBattery( !preferenceService.getShowBattery() );
				showBattery.setChecked( preferenceService.getShowBattery() );
				return true;
			} );
		}
	}
}