package com.ensoft.ace.view.activity;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.PatientCard;

import java.util.Calendar;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class PatientCardActivity extends BaseActivity
{
	@BindView( R.id.card_date_sel )
	protected EditText dateText;

	private final Calendar calendar = Calendar.getInstance();
	private int year = 0;
	private int month = 0;
	private int day = 0;

	private DatePickerDialog.OnDateSetListener dateSetListener = ( view, year, monthOfYear, dayOfMonth ) -> {
		PatientCardActivity.this.year = year;
		month = monthOfYear;
		day = dayOfMonth;
		updateDisplay();
	};

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		setContentView( R.layout.activity_patient_card );

		ButterKnife.bind( this );

		day = calendar.get( Calendar.DAY_OF_MONTH );
		month = calendar.get( Calendar.MONTH );
		year = calendar.get( Calendar.YEAR );

		updateDisplay();
		addGendersToSpinner();
		assignData();
	}

	private void assignData()
	{
		Intent intent = getIntent();
		PatientCard pcd = intent.getParcelableExtra( "patientCardData" );
		if ( pcd != null )
		{
			EditText et = (EditText) findViewById( R.id.patient_name_edit );
			et.setText( pcd.getFullName() );
			et = (EditText) findViewById( R.id.email_edit );
			et.setText( pcd.getEmailAddress() );
			if ( pcd.getAge() != -1 )
			{
				et = (EditText) findViewById( R.id.age_edit );
				et.setText( Integer.toString( pcd.getAge() ) );
			}
			et = (EditText) findViewById( R.id.city_edit );
			et.setText( pcd.getCity() );
			et = (EditText) findViewById( R.id.phone_edit );
			et.setText( pcd.getPhoneNumber() );
			et = (EditText) findViewById( R.id.welfare_edit );
			et.setText( pcd.getMedicalInsurance() );
			if ( pcd.getFlowmetryNumber() != -1 )
			{
				et = (EditText) findViewById( R.id.flowmetryNumber_edit );
				et.setText( Integer.toString( pcd.getFlowmetryNumber() ) );
			}
			et = (EditText) findViewById( R.id.observations_edit );
			et.setText( pcd.getObservations() );
			if ( pcd.isValidDate() )
			{
				this.day = pcd.getDateDay();
				this.month = pcd.getDateMonth() - 1;
				this.year = pcd.getDateYear();
				updateDisplay();
			}

			if ( pcd.getGender() != null && !pcd.getGender().isEmpty() )
			{
				Spinner spinner = (Spinner) findViewById( R.id.gender_spinner );
				if ( pcd.getGender().equals( "Hombre" ) )
				{
					spinner.setSelection( 1 );
				}
				else
				{
					spinner.setSelection( 2 );
				}
			}
		}
	}

	protected void updateDisplay()
	{
		dateText.setText( new StringBuilder()
						.append( day ).append( "/" )
						// Month is 0 based so add 1
						.append( month + 1 ).append( "/" )
						.append( year ).append( " " )
						);
	}

	protected void addGendersToSpinner()
	{
		Spinner spinner = (Spinner) findViewById( R.id.gender_spinner );
		String[] genders = getResources().getStringArray( R.array.gender_array );

		ArrayAdapter<String> adapter = new ArrayAdapter<String>( this, android.R.layout.simple_spinner_dropdown_item, genders )
		{
			@Override
			public View getView( int position, View convertView, ViewGroup parent )
			{
				View v = super.getView( position, convertView, parent );

				if ( position == 0 )
				{
					( (TextView) v.findViewById( android.R.id.text1 ) ).setText( "" );
					( (TextView) v.findViewById( android.R.id.text1 ) ).setHint( getItem( 0 ) ); //"Hint to be displayed"
				}

				return v;
			}
		};

		adapter.setDropDownViewResource( android.R.layout.simple_spinner_dropdown_item );
		spinner.setSelection( genders.length ); //display hint
		spinner.setAdapter( adapter );
	}

	@OnClick( R.id.card_date_sel )
	protected void onDateSelectClick( View view )
	{
		new DatePickerDialog( PatientCardActivity.this, dateSetListener, year, month, day ).show();
	}

	@OnClick( R.id.save_card_but )
	protected void onSaveClick( View view )
	{
		PatientCard pcd = getPatientCardDataFromControls();

		if ( null == pcd.getFullName() || pcd.getFullName().isEmpty() )
		{
			Toast.makeText( getBaseContext(), "Debe ingresar al menos el nombre del paciente.", Toast.LENGTH_LONG ).show();
		}
		else
		{
			Intent resultIntent = new Intent();
			resultIntent.putExtra( "patientCardData", pcd );
			setResult( Activity.RESULT_OK, resultIntent );
			Toast.makeText( getBaseContext(), "Ficha del paciente guardada", Toast.LENGTH_LONG ).show();
			finish();
		}
	}

	private PatientCard getPatientCardDataFromControls()
	{
		PatientCard pcd = new PatientCard();
		EditText et = (EditText) findViewById( R.id.patient_name_edit );
		pcd.setFullName( et.getText().toString() );
		et = (EditText) findViewById( R.id.email_edit );
		pcd.setEmailAddress( et.getText().toString() );
		et = (EditText) findViewById( R.id.age_edit );

		if ( !et.getText().toString().isEmpty() )
		{
			pcd.setAge( Integer.parseInt( et.getText().toString() ) );
		}

		et = (EditText) findViewById( R.id.city_edit );
		pcd.setCity( et.getText().toString() );
		et = (EditText) findViewById( R.id.phone_edit );
		pcd.setPhoneNumber( et.getText().toString() );
		et = (EditText) findViewById( R.id.welfare_edit );
		pcd.setMedicalInsurance( et.getText().toString() );
		et = (EditText) findViewById( R.id.flowmetryNumber_edit );

		if ( !et.getText().toString().isEmpty() )
		{
			pcd.setFlowmetryNumber( Integer.parseInt( et.getText().toString() ) );
		}

		et = (EditText) findViewById( R.id.observations_edit );
		pcd.setObservations( et.getText().toString() );
		pcd.setDate( this.year, this.month+1, this.day );
		Spinner sp = (Spinner) findViewById( R.id.gender_spinner );
		if ( sp.getSelectedItemPosition() != 0 )
		{
			pcd.setGender( sp.getSelectedItem().toString() );
		}

		return pcd;
	}
}
