package com.ensoft.ace.view.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.Flowmetry;

public class NomogramMenuActivity extends BaseActivity
{
	protected final String EXTRA_FLOWMETRY_DATA = "flowmetryData";
	protected Flowmetry flowmetry;

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_nomogram_menu );

		flowmetry = getIntent().getExtras().getParcelable( "flowmetryData" );
	}

	protected void showLiverpoolMales()
	{
		Intent intent = new Intent( this, LiverpoolNomogramMalesActivity.class );
		intent.putExtra( EXTRA_FLOWMETRY_DATA, flowmetry );
		startActivity( intent );
	}

	protected void showLiverpoolFemales()
	{
		Intent intent = new Intent( this, LiverpoolNomogramFemalesActivity.class );
		intent.putExtra( EXTRA_FLOWMETRY_DATA, flowmetry );
		startActivity( intent );
	}

	public void onClick( View v )
	{
		final int id = v.getId();

		switch ( id )
		{
			case R.id.see_liverpool_males:
			{
				showLiverpoolMales();
				break;
			}
			case R.id.see_liverpool_females:
			{
				showLiverpoolFemales();
				break;
			}
		}
	}
}
