package com.ensoft.ace.view.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

import com.ensoft.ace.R;
import com.ensoft.ace.infrastructure.service.FileService;
import com.ensoft.ace.view.widget.SimpleFileDialog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class MedicReportActivity extends BaseActivity
{
	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_medic_report );
		setReportData();
	}

	private void setReportData()
	{
		Intent parentIntent = getIntent();
		String report = parentIntent.getStringExtra( "report" );
		if ( report != null && !report.isEmpty() )
		{
			EditText et = (EditText) findViewById( R.id.txtReport );
			et.setText( report );
		}
	}

	public void onClick( View v )
	{
		final int id = v.getId();

		switch ( id )
		{
			case R.id.btnSave:
			{
				EditText et = (EditText) findViewById( R.id.txtReport );
				String report = et.getText().toString();
				Intent resultIntent = new Intent();
				resultIntent.putExtra( "report", report );
				setResult( Activity.RESULT_OK, resultIntent );
				Toast.makeText( getBaseContext(), "Cambios en informe guardados", Toast.LENGTH_LONG ).show();
				finish();
				break;
			}
			case R.id.btnOpenTemplate:
			{
				SimpleFileDialog FileOpenDialog = new SimpleFileDialog( MedicReportActivity.this, "FileOpen",
						chosenDir -> readFileAndSetReport( chosenDir ), new FileService().getReportSaveDir() );

				FileOpenDialog.DEFAULT_FILE_NAME = "";
				FileOpenDialog.chooseFileOrDir();

				break;
			}
			case R.id.btnSaveTemplate:
			{
				SimpleFileDialog FileSaveDialog = new SimpleFileDialog( MedicReportActivity.this, "FileSave",
						chosenDir -> createReportTemplate( chosenDir ), new FileService().getReportSaveDir() );

				FileSaveDialog.DEFAULT_FILE_NAME = "informetipo.txt";
				FileSaveDialog.chooseFileOrDir();

				break;
			}
		}
	}

	private void createReportTemplate( String chosenDir )
	{
		try
		{
			File file = new File( chosenDir );
			// If file does not exists, then create it
			if ( !file.exists() )
			{
				file.createNewFile();
			}
			FileWriter fw = new FileWriter( file.getAbsoluteFile() );
			BufferedWriter bw = new BufferedWriter( fw );
			EditText et = (EditText) findViewById( R.id.txtReport );
			bw.write( et.getText().toString() );
			bw.close();
			Toast.makeText( getBaseContext(), "Informe tipo guardado exitosamente", Toast.LENGTH_LONG ).show();
		}
		catch ( IOException e )
		{
			e.printStackTrace();
		}
	}

	private void readFileAndSetReport( String chosenDir )
	{
		File file = new File( chosenDir );

		StringBuilder text = new StringBuilder();

		try
		{
			BufferedReader br = new BufferedReader( new FileReader( file ) );
			String line;

			while ( ( line = br.readLine() ) != null )
			{
				text.append( line );
				text.append( '\n' );
			}
			br.close();
			Toast.makeText( getBaseContext(), "Informe tipo cargado exitosamente", Toast.LENGTH_LONG ).show();
		}
		catch ( IOException e )
		{
			//You'll need to add proper error handling here
		}

		EditText et = (EditText) findViewById( R.id.txtReport );
		et.setText( text );
	}
}
