package com.ensoft.ace.view.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import com.ensoft.ace.R;

public class MainActivity extends BaseActivity
{
	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_main );
	}

	@Override
	public boolean onCreateOptionsMenu( Menu menu )
	{
		getMenuInflater().inflate( R.menu.main, menu );
		return true;
	}

	@Override
	public boolean onOptionsItemSelected( MenuItem item )
	{
		int id = item.getItemId();

		if ( id == R.id.action_calibrate )
		{
			starCalibration();
			return true;
		}
		else if ( id == R.id.action_settings )
		{
			startConfig();
			return true;
		}

		return super.onOptionsItemSelected( item );
	}

	private void startConfig()
	{
		Intent settingsActivity = new Intent( getBaseContext(), PreferencesActivity.class );
		startActivity( settingsActivity );
	}

	protected void starCalibration()
	{
		Intent calibrationActivity = new Intent( getBaseContext(), CalibrationActivity.class );
		startActivity( calibrationActivity );
	}

	public void onClick( View v )
	{
		final int id = v.getId();

		switch ( id )
		{
			case R.id.new_studio_but:
				startActivity( new Intent( MainActivity.this, FlowmetryCaptureActivity.class ) );
				break;
			case R.id.load_studio_but:
				StudySearchActivity.newInstance( this, StudySearchActivity.SearchType.Load );
				break;
			case R.id.delete_studio_but:
				StudySearchActivity.newInstance( this, StudySearchActivity.SearchType.Delete );
				break;
			case R.id.send_studio_but:
				StudySearchActivity.newInstance( this, StudySearchActivity.SearchType.Send );
				break;
			case R.id.battery_state_but:
				BatteryStatusActivity.newInstance( this );
				break;
		}
	}

	@Override
	public void onBackPressed()
	{
		moveTaskToBack( true );
	}
}
