package com.ensoft.ace.view.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.Flowmetry;
import com.ensoft.ace.domain.service.flowmetry.FlowmetryStudyFile;
import com.ensoft.ace.infrastructure.service.FileService;
import com.ensoft.ace.view.export.FlowmetryEscPos;
import com.ensoft.ace.view.export.FlowmetryPdf;
import com.ensoft.ace.view.widget.SimpleFileDialog;

public class FlowmetryResultActivity extends BaseActivity
{
	private final String EXTRA_PATIENT_CARD_DATA = "patientCardData";
	private final String EXTRA_SURVEY_IPSS = "surveyIPSS";
	private final String EXTRA_REPORT = "report";
	private final String EXTRA_FLOWMETRY_DATA = "flowmetryData";

	private final int RC_PATIENT_CARD = 1;
	private final int RC_SURVEY_IPSS = 2;
	private final int RC_REPORT = 3;

	private FlowmetryStudyFile flowmetryStudyFile;

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_flowmetry_result );

		flowmetryStudyFile = new FlowmetryStudyFile();

		Intent intent = getIntent();

		if ( intent.getStringExtra( "chosenDir" ) == null )
		{
			showPatient();
		}
		else
		{
			flowmetryStudyFile.load( intent.getStringExtra( "chosenDir" ) );
		}

		if ( intent.getParcelableExtra( EXTRA_FLOWMETRY_DATA ) != null )
		{
			flowmetryStudyFile.setFlowmetry( intent.getParcelableExtra( EXTRA_FLOWMETRY_DATA ) );
		}
	}

	protected void saveFlowmetry()
	{
		SimpleFileDialog FileSaveDialog = new SimpleFileDialog( FlowmetryResultActivity.this, "FileSave",
				chosenDir -> {
					if ( flowmetryStudyFile.save( chosenDir ) )
						Toast.makeText( getBaseContext(), "Estudio guardado exitosamente", Toast.LENGTH_LONG ).show();
				}, new FileService().getStudySaveDir() );

		FileSaveDialog.DEFAULT_FILE_NAME = flowmetryStudyFile.getFlowmetryFileName();
		FileSaveDialog.chooseFileOrDir();
	}

	protected void showReport()
	{
		Intent intent = new Intent( this, MedicReportActivity.class );

		if ( flowmetryStudyFile.getReport() != null && !flowmetryStudyFile.getReport().isEmpty() )
		{
			intent.putExtra( EXTRA_REPORT, flowmetryStudyFile.getReport() );
		}

		startActivityForResult( intent, RC_REPORT );
	}

	protected void showPatient()
	{
		Intent intent = new Intent( this, PatientCardActivity.class );

		if ( flowmetryStudyFile.getPatientCard() != null )
		{
			intent.putExtra( EXTRA_PATIENT_CARD_DATA, flowmetryStudyFile.getPatientCard() );
		}

		startActivityForResult( intent, RC_PATIENT_CARD );
	}

	protected void onActivityResult( int requestCode, int resultCode, Intent data )
	{
		super.onActivityResult( requestCode, resultCode, data );
		if ( requestCode == RC_PATIENT_CARD )
		{
			if ( resultCode == RESULT_OK )
			{
				flowmetryStudyFile.setPatientCard( data.getParcelableExtra( EXTRA_PATIENT_CARD_DATA ) );

				if ( flowmetryStudyFile.save( flowmetryStudyFile.getFlowmetryFileSavePath() ) )
					Toast.makeText( getBaseContext(), "Estudio guardado exitosamente", Toast.LENGTH_LONG ).show();

				new FlowmetryPdf( this, flowmetryStudyFile.getFlowmetry(), flowmetryStudyFile.getPatientCard(), flowmetryStudyFile.getReport(), FlowmetryPdf.Mode.SAVE, 2 );
			}
		}
		else if ( requestCode == RC_SURVEY_IPSS )
		{
			if ( resultCode == RESULT_OK )
			{
				flowmetryStudyFile.setAnswers( data.getIntegerArrayListExtra( EXTRA_SURVEY_IPSS ) );
			}
		}
		else if ( requestCode == RC_REPORT )
		{
			if ( resultCode == RESULT_OK )
			{
				flowmetryStudyFile.setReport( data.getStringExtra( EXTRA_REPORT ) );
				flowmetryStudyFile.save( flowmetryStudyFile.getFlowmetryFileSavePath() );
			}
		}
	}

	protected void showFlowmetryReport()
	{
		Intent intent = new Intent( this, FlowmetryReportActivity.class );
		intent.putExtra( EXTRA_FLOWMETRY_DATA, flowmetryStudyFile.getFlowmetry() );
		startActivity( intent );
	}

	private void showSurveyIPSS()
	{
		Intent intent = new Intent( this, SurveyIPSSActivity.class );

		if ( flowmetryStudyFile.getAnswers() != null && !flowmetryStudyFile.getAnswers().isEmpty() )
		{
			intent.putExtra( EXTRA_SURVEY_IPSS, flowmetryStudyFile.getAnswers() );
		}

		startActivityForResult( intent, RC_SURVEY_IPSS );
	}

	protected void showNomogram()
	{
		Intent intent = new Intent( this, NomogramMenuActivity.class );
		intent.putExtra( EXTRA_FLOWMETRY_DATA, flowmetryStudyFile.getFlowmetry() );
		startActivity( intent );
	}

	public void onClick( View v )
	{
		final int id = v.getId();

		switch ( id )
		{
			case R.id.see_patient_card_but:
			{
				showPatient();
				break;
			}
			case R.id.see_report_but:
			{
				showReport();
				break;
			}
			case R.id.see_flowmetry_report_but:
			{
				showFlowmetryReport();
				break;
			}
			case R.id.see_nemogram_but:
			{
				showNomogram();
				break;
			}
			case R.id.see_ipss_but:
			{
				showSurveyIPSS();
				break;
			}
			case R.id.send_mail_but:
			{
				new MaterialDialog.Builder( this )
						.title( R.string.create )
						.items( R.array.pdf_options )
						.itemsCallbackSingleChoice( -1, ( dialog, view, which, text ) -> {
							if ( which >= 0 )
							{
								new FlowmetryPdf( FlowmetryResultActivity.this, flowmetryStudyFile.getFlowmetry(), flowmetryStudyFile.getPatientCard(), flowmetryStudyFile.getReport(), FlowmetryPdf.Mode.SHARE, which + 1 );
							}

							return true;
						} )
						.positiveText( R.string.accept )
						.show();

				break;
			}
			case R.id.print_flowmetry_but:
			{
				new MaterialDialog.Builder( this )
						.title( R.string.print )
						.items( R.array.pdf_options )
						.itemsCallbackSingleChoice( -1, ( dialog, view, which, text ) -> {
							if ( which >= 0 )
							{
								new FlowmetryEscPos( FlowmetryResultActivity.this, flowmetryStudyFile.getFlowmetry(), flowmetryStudyFile.getPatientCard(), flowmetryStudyFile.getReport(), which + 1 );
							}

							return true;
						} )
						.positiveText( R.string.accept )
						.show();
				break;
			}
			case R.id.save_flowmetry_but:
			{
				saveFlowmetry();
				break;
			}
			case R.id.report_goout_but:
			{
				finish();
				break;
			}
			case R.id.see_graph:
			{
				showGraph();
				break;
			}
		}
	}

	protected void showGraph()
	{
		Flowmetry flowmetry = flowmetryStudyFile.getFlowmetry();
		Intent intent = new Intent( this, FlowmetryCaptureActivity.class );
		intent.putExtra( "scrollView", false );
		intent.putExtra( "flowHist", flowmetry.getFlowHist() );
		intent.putExtra( "volumHist", flowmetry.getVolumHist() );
		intent.putExtra( "timeInit", flowmetry.getTimeInit() );
		intent.putExtra( "timeEnd", flowmetry.getTimeEnd() );
		startActivity( intent );
	}
}
