package com.ensoft.ace.view.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.TextView;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.Flowmetry;

public class FlowmetryReportActivity extends BaseActivity
{
	private Flowmetry flowmetry;

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_study_results );

		assignData();

	}

	private void assignData()
	{
		Intent intent = getIntent();
		flowmetry = intent.getParcelableExtra( "flowmetryData" );
		if ( flowmetry != null )
		{
			flowmetry.findResults();
			TextView textView = findViewById( R.id.lblQMaximoVal );
			textView.setText( flowmetry.getQMax() + " ml/seg" );

			textView = findViewById( R.id.lblQPromedioVal );
			textView.setText( String.format( "%.2f", flowmetry.getQAverage() ) + " ml/seg" );

			textView = findViewById( R.id.lblQADosSegVal );
			textView.setText( flowmetry.getQAt2Seconds() + " ml/seg" );

			textView = findViewById( R.id.lblTAQMaxVal );
			textView.setText( flowmetry.getQMaxTime() + " seg" );

			textView = findViewById( R.id.lblVolTotalVal );
			textView.setText( flowmetry.getTotalVol() + " ml" );

			textView = findViewById( R.id.lblVolHastaQMaxVal );
			textView.setText( flowmetry.getVolAtQMaxTime() + " ml" );

			textView = findViewById( R.id.lblTiempoTotalVal );
			textView.setText( flowmetry.getTotalTime() + " seg" );

			textView = findViewById( R.id.lblTiempoNetoVal );
			textView.setText( ( flowmetry.getNetTime() ) + " seg" );

			textView = findViewById( R.id.lblTiempoDescVal );
			textView.setText( flowmetry.getTotalDescTime() + " seg" );

			textView = findViewById( R.id.lblTiempoPausasVal );
			textView.setText( flowmetry.getTimePaused() + " seg" );
		}
	}
}
