package com.ensoft.ace.view.activity;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import android.view.View;
import android.widget.TextView;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.ace.R;
import com.ensoft.ace.domain.service.emitter.Emitter;
import com.ensoft.ace.domain.service.emitter.EmitterBluetooth;
import com.ensoft.ace.infrastructure.listener.BluetoothDeviceStatusListener;
import com.ensoft.ace.infrastructure.listener.EmitterConnectionResultListener;
import com.ensoft.ace.infrastructure.service.BluetoothDeviceFinderService;
import com.ensoft.ace.infrastructure.service.PreferenceService;

public class CalibrationActivity extends BaseActivity implements BluetoothDeviceStatusListener, EmitterConnectionResultListener
{
	protected Emitter emitter = null;
	protected long offset = 0;
	protected long value = 0;
	protected TextView valueTextView;
	protected BluetoothDeviceFinderService finderService = null;
	
	protected final Handler.Callback callback = new Handler.Callback()
	{
		public boolean handleMessage( Message msg )
		{
			value = msg.arg1 - offset;
			valueTextView.setText( value / 4.f + "ml" );
			return true;
		}
	};

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_calibrate );
		
		keepScreenOn();
		
		valueTextView = findViewById( R.id.lblValor );

		if ( null != getSupportActionBar() )
		{
			getSupportActionBar().setTitle( "Calibración" );
		}
		
		finderService = new BluetoothDeviceFinderService( this, this, new PreferenceService().getBluetoothName() );
	}

	@Override
	protected void onDestroy()
	{
		if ( null != emitter )
		{
			emitter.end();
		}

		super.onDestroy();
	}

	public void emitterInit( BluetoothDevice device )
	{
		if ( null != emitter )
		{
			emitter.end();
			emitter = null;
		}

		emitter = new EmitterBluetooth( device );
		//emitter = new EmitterSimulator();
		emitter.init( this, callback, this );
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		super.onActivityResult( requestCode, resultCode, data );
		if ( null != finderService )
			finderService.onActivityResult( requestCode, resultCode, data );
	}
	
	public void onClick( View v )
	{
		final int id = v.getId();

		switch ( id )
		{
			case R.id.save_as_zero_but:
				offset = value;
				break;
			case R.id.back_but:
				onBackPressed();
				break;
		}
	}
	
	@Override
	public void onDeviceFound( BluetoothAdapter bluetoothAdapter, BluetoothDevice bluetoothDevice )
	{
		emitterInit( bluetoothDevice );
	}
	
	@Override
	public void onDeviceNotFound()
	{
		try
		{
			errorMessage( getString( R.string.bt_connection_error ), ( dialog, which ) -> finish() );
		}
		catch ( Exception ignore ) {}
	}
	
	@Override
	public void onEmitterConnectionSuccess()
	{
		
	}
	
	@Override
	public void onEmitterConnectionFail( String message )
	{
		onDeviceNotFound();
	}
}
