package com.ensoft.ace.view.activity;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.service.emitter.EmitterBluetooth;
import com.ensoft.ace.infrastructure.listener.BluetoothDeviceStatusListener;
import com.ensoft.ace.infrastructure.listener.EmitterConnectionResultListener;
import com.ensoft.ace.infrastructure.service.BluetoothDeviceFinderService;
import com.ensoft.ace.infrastructure.service.PreferenceService;
import com.ensoft.ace.view.widget.BatteryView;

import butterknife.BindView;
import butterknife.ButterKnife;

public class BatteryStatusActivity extends BaseActivity implements BluetoothDeviceStatusListener, EmitterConnectionResultListener
{
	@BindView( R.id.battery_status_obtaining)
	TextView batteryTextView;

	@BindView( R.id.battery_status )
	BatteryView batteryView;

	protected BluetoothDeviceFinderService finderService = null;
	EmitterBluetooth emitter;

	public static void newInstance( Context context )
	{
		Intent activity = new Intent( context, BatteryStatusActivity.class );
		context.startActivity( activity );
	}

	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		setContentView( R.layout.activity_battery_status );

		ButterKnife.bind( this );

		setTitle( R.string.battery_status );

		finderService = new BluetoothDeviceFinderService( this, this, new PreferenceService().getBluetoothName() );
	}

	@Override
	protected void onDestroy()
	{
		if ( null != emitter )
		{
			emitter.end();
		}

		super.onDestroy();
	}

	public void emitterInit( BluetoothDevice device )
	{
		if ( null != emitter )
		{
			emitter.end();
			emitter = null;
		}

		emitter = new EmitterBluetooth( device );
		emitter.init( this, this );
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		super.onActivityResult( requestCode, resultCode, data );
		if ( null != finderService )
			finderService.onActivityResult( requestCode, resultCode, data );
	}

	@Override
	public void onEmitterConnectionSuccess()
	{
		int battery = emitter.getCurrentBattery();
		if ( battery != Integer.MIN_VALUE )
		{
			batteryTextView.setText( R.string.battery_status );
			batteryView.setVisibility( View.VISIBLE );
			batteryView.setBatteryLevel( battery );
		}
		else
		{
			batteryTextView.setText( R.string.battery_error );
			new PreferenceService().setShowBattery( false );
		}
	}

	@Override
	public void onEmitterConnectionFail( String message )
	{
		onDeviceNotFound();
	}

	@Override
	public void onDeviceFound( BluetoothAdapter bluetoothAdapter, BluetoothDevice bluetoothDevice )
	{
		emitterInit( bluetoothDevice );
	}

	@Override
	public void onDeviceNotFound()
	{
		errorMessage( getString( R.string.bt_connection_error ), ( dialog, which ) -> finish() );
	}
}
