package com.ensoft.ace.view.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.LinearLayout;

import com.ensoft.ace.R;
import com.ensoft.ace.domain.model.Flowmetry;
import com.ensoft.ace.infrastructure.service.LiverpoolNomogramService;
import com.jjoe64.graphview.GraphView;

public abstract class BaseLiverpoolNomogramActivity extends BaseActivity
{
	protected final String EXTRA_FLOWMETRY_DATA = "flowmetryData";
	protected Flowmetry flowmetry;
	LiverpoolNomogramService liverpoolNomogramService;
	
	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_nomogram );

		Intent intent = getIntent();
		if ( intent.getParcelableExtra( EXTRA_FLOWMETRY_DATA ) != null )
		{
			flowmetry = intent.getParcelableExtra( EXTRA_FLOWMETRY_DATA );
		}
		
		liverpoolNomogramService = createService();
		
		GraphView graficoAve = liverpoolNomogramService.getAverageGraph();
		GraphView graficoVolMax = liverpoolNomogramService.getVolMaxGraph();
		
		graficoAve.getViewport().setMaxY( 40 );
		
		//Se agregan los graficos a la vista
		LinearLayout layout = (LinearLayout) findViewById( R.id.layoutMaxVol );
		layout.addView( graficoVolMax );
		layout = (LinearLayout) findViewById( R.id.layoutAve );
		layout.addView( graficoAve );
	}
	
	protected abstract LiverpoolNomogramService createService();
}
