package com.ensoft.ace.view.activity;

import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import android.view.WindowManager;

import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.ace.R;

public class BaseActivity extends AppCompatActivity
{
	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );

		if ( null != getSupportActionBar() )
		{
			if ( android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP )
			{
				getSupportActionBar().setElevation( 0 );
			}
		}
	}

	public void setTitle( String title )
	{
		if ( null != getSupportActionBar() )
		{
			getSupportActionBar().setTitle( title );
		}
	}

	@Override
	public void setTitle( int id )
	{
		setTitle( getString( id ) );
	}

	public void keepScreenOn()
	{
		getWindow().addFlags( WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON );
	}

	public void alertMessage( String title, String message, String okText, MaterialDialog.SingleButtonCallback onOkClick )
	{
		new MaterialDialog.Builder(this)
			.title( title )
			.content( message )
			.positiveText( okText )
			.onPositive( onOkClick )
			.show();
	}

	public void alertMessage( String title, String message, String okText )
	{
		alertMessage( title, message, okText, null );
	}

	public void alertMessage( String title, String message, MaterialDialog.SingleButtonCallback onOkClick )
	{
		alertMessage( title, message, getString( R.string.ok ), onOkClick );
	}

	public void alertMessage( String title, String message )
	{
		alertMessage( title, message, getString( R.string.ok ), null );
	}

	public void errorMessage( String message )
	{
		alertMessage( getString( R.string.error ), message, getString( R.string.ok ) );
	}
	
	public void errorMessage( String message, MaterialDialog.SingleButtonCallback onOkClick )
	{
		alertMessage( getString( R.string.error ), message, getString( R.string.ok ), onOkClick );
	}
}
