package com.ensoft.ace.infrastructure.service;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;

/**
 * This class uses the AccountManager to get the primary email address of the
 * current user.
 */
public class UserEmailService
{
	public String getEmail( Context context )
	{
		AccountManager accountManager = AccountManager.get( context );
		Account account = getAccount( accountManager );

		if ( account == null )
		{
			return null;
		}
		else
		{
			return account.name;
		}
	}

	private Account getAccount( AccountManager accountManager )
	{
		Account account = null;

		try
		{
			Account[] accounts = accountManager.getAccountsByType( "com.google" );

			if ( accounts.length > 0 )
			{
				account = accounts[0];
			}
		}
		catch ( SecurityException e )
		{}

		return account;
	}
}