package com.ensoft.ace.infrastructure.service;

import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import com.ensoft.ace.App;

public class PreferenceService
{
	private SharedPreferences sharedPreferences;

	public PreferenceService()
	{
		sharedPreferences = PreferenceManager.getDefaultSharedPreferences(App.instance);
	}

	public int getLatency()
	{
		return Integer.parseInt( sharedPreferences.getString( "latencyPref", "100" ) );
	}

	public String getBluetoothName()
	{
		return sharedPreferences.getString( "btNamePref", "Ace Blue" );
	}


	public boolean getShowBattery()
	{
		return sharedPreferences.getBoolean( "btShowBattery", true );
	}

	public void setShowBattery( boolean show )
	{
		sharedPreferences.edit().putBoolean( "btShowBattery", show ).apply();
	}
}
