package com.ensoft.ace.infrastructure.service;

import android.content.Context;

import com.ensoft.ace.domain.model.Flowmetry;
import com.jjoe64.graphview.DefaultLabelFormatter;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.LegendRenderer;
import com.jjoe64.graphview.series.DataPoint;
import com.jjoe64.graphview.series.Series;

import java.text.NumberFormat;
import java.util.List;

public abstract class LiverpoolNomogramService
{
	protected Context context;
	protected Flowmetry flowmetry;
	protected GraphView volMaxGraph;
	protected GraphView averageGraph;
	protected boolean fromEscPos;
	
	public LiverpoolNomogramService( Context context, Flowmetry flowmetry, boolean fromEscPos )
	{
		this.context = context;
		this.flowmetry = flowmetry;
		this.fromEscPos = fromEscPos;
		
		volMaxGraph = initGraphProperties( context, getSeriesGraphLeft(), "Tasa de flujo maxima (ml/s)", 60 );
		averageGraph = initGraphProperties( context, getSeriesGraphRight(), "Tasa de flujo promedio (ml/s)", 40 );
	}
	
	protected abstract List<Series<DataPoint>> getSeriesGraphLeft();
	
	protected abstract List<Series<DataPoint>> getSeriesGraphRight();
	
	protected GraphView initGraphProperties( Context context, List<Series<DataPoint>> series, String yTitle, int maxY )
	{
		GraphView graphView = new GraphView( context );
		graphView.getViewport().setScrollable( false );
		
		graphView.getViewport().setXAxisBoundsManual( true );
		graphView.getViewport().setMinX( 0 );
		graphView.getViewport().setMaxX( 600 );
		
		for ( Series<DataPoint> serie : series )
		{
			graphView.addSeries( serie );
		}
		
		graphView.setBackgroundColor( 0xFFFFFFFF );
		graphView.getLegendRenderer().setVisible( true );
		graphView.getLegendRenderer().setAlign( LegendRenderer.LegendAlign.TOP );
		graphView.getViewport().setYAxisBoundsManual( true );
		graphView.getViewport().setMinY( 0 );
		graphView.getViewport().setMaxY( maxY );

		NumberFormat nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits( 0 );
		nf.setMinimumFractionDigits( 0 );
		graphView.getGridLabelRenderer().setLabelFormatter( new DefaultLabelFormatter( nf, nf ) );
		graphView.getGridLabelRenderer().setHorizontalAxisTitle( "Volumen evacuado (ml)" );
		graphView.getGridLabelRenderer().setVerticalAxisTitle( yTitle );
		
		return graphView;
	}
	
	public GraphView getVolMaxGraph()
	{
		return volMaxGraph;
	}
	
	public GraphView getAverageGraph()
	{
		return averageGraph;
	}
}
